/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class WhineAtBowlGoal
extends Goal {
    private final Wolf wolf;
    private BlockPos bowlPos;
    private Vec3 lastTargetPos;
    private int whineTicks;
    private int fadeOutTicks;
    private long lastScanTick;
    private long lastWhineSoundTick;
    private boolean active;
    private static final int SCAN_INTERVAL_TICKS = 40;
    private static final int MAX_WHINE_TICKS = 300;
    private static final int WHINE_INTERVAL = 60;
    private static final int ANGRY_PARTICLE_INTERVAL = 100;
    private static final int WHINE_PARTICLE_COUNT = 6;
    private static final int FINAL_PARTICLE_COUNT = 15;
    private static final int FADE_OUT_DURATION = 30;
    private static final double BASE_SPEED = 1.0;
    private static final double EVENING_SPEED_FACTOR = 0.8;
    private static final double CLOSE_ENOUGH_DIST = 1.1;
    private static final float BASE_VOLUME = 0.4f;
    private static final float BASE_PITCH = 0.4f;
    private static final int LOOK_YAW = 10;
    private static final int LOOK_PITCH = 30;
    private static final int RANGE_XZ = 10;
    private static final int RANGE_Y = 2;
    private static final long MORNING_START = 5800L;
    private static final long MORNING_END = 6200L;
    private static final long EVENING_START = 11500L;
    private static final long EVENING_END = 12500L;
    private static final double NAVIGATION_RECALC_THRESHOLD_SQR = 0.5;
    private static final List<SoundEvent> WHINE_SOUNDS = List.of(SoundEvents.WOLF_WHINE, SoundEvents.WOLF_PANT);

    public WhineAtBowlGoal(Wolf wolf) {
        this.wolf = wolf;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.whineTicks = 0;
        this.lastScanTick = -40L;
        this.lastWhineSoundTick = -60L;
        this.active = false;
        this.lastTargetPos = null;
    }

    public boolean canUse() {
        if (!this.wolf.isAlive() || !this.wolf.isTame() || this.wolf.isOrderedToSit()) {
            return false;
        }
        Level level = this.wolf.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        if (!this.shouldScanForBowl(server.getGameTime())) {
            return false;
        }
        if (!this.isValidWhineTime(server.getDayTime())) {
            return false;
        }
        BlockPos wolfPos = this.wolf.blockPosition();
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)wolfPos.offset(-10, -2, -10), (BlockPos)wolfPos.offset(10, 2, 10))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            if (!this.wolf.level().getBlockState(pos).is((Block)ObjectRegistry.PET_BOWL.get()) || !((be = this.wolf.level().getBlockEntity(pos)) instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).isEmpty() || !bowl.canBeUsedBy((Animal)this.wolf) || !((dist = this.wolf.position().distanceToSqr(Vec3.atCenterOf((Vec3i)pos))) < closestDistance)) continue;
            closestDistance = dist;
            closest = pos.immutable();
        }
        if (closest != null) {
            this.bowlPos = closest;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        PetBowlBlockEntity bowl;
        if (!this.active || !this.wolf.isAlive() || this.bowlPos == null) {
            return false;
        }
        Level level = this.wolf.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.getBlockEntity(this.bowlPos);
        return be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).isEmpty() && bowl.canBeUsedBy((Animal)this.wolf);
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        PetBowlBlockEntity bowl;
        Level level = this.wolf.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.getBlockEntity(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).isEmpty() && bowl.canBeUsedBy((Animal)this.wolf))) {
            this.stop();
            return;
        }
        this.wolf.setOrderedToSit(false);
        this.moveToBowl(server.getDayTime());
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.lastWhineSoundTick = -60L;
        this.active = true;
    }

    public void tick() {
        LivingEntity owner;
        PetBowlBlockEntity bowl;
        ServerLevel server;
        block17: {
            block16: {
                Level level = this.wolf.level();
                if (!(level instanceof ServerLevel)) break block16;
                server = (ServerLevel)level;
                if (this.wolf.isAlive()) break block17;
            }
            this.stop();
            return;
        }
        BlockEntity be = server.getBlockEntity(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).isEmpty()) {
            this.stop();
            return;
        }
        Vec3 bowlCenter = Vec3.atCenterOf((Vec3i)this.bowlPos);
        if (this.isNearBowl()) {
            if (this.wolf.getNavigation().isInProgress()) {
                this.wolf.getNavigation().stop();
            }
            if (!this.wolf.isInSittingPose()) {
                this.wolf.setOrderedToSit(true);
            }
            this.wolf.getLookControl().setLookAt(bowlCenter.x, bowlCenter.y, bowlCenter.z, 10.0f, 30.0f);
        } else {
            if (this.wolf.isInSittingPose()) {
                this.wolf.setOrderedToSit(false);
            }
            if (!this.wolf.getNavigation().isInProgress() || this.needsRepath(bowlCenter)) {
                this.moveToBowl(server.getDayTime());
            }
        }
        if ((long)this.whineTicks - this.lastWhineSoundTick >= 60L) {
            this.playWhineSound();
            this.lastWhineSoundTick = this.whineTicks;
        }
        if (this.whineTicks % 100 == 0) {
            Vec3 pos = this.wolf.position().add(0.0, 0.5, 0.0);
            server.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y, pos.z, 6, 0.3, 0.3, 0.3, 0.01);
        }
        if ((owner = this.wolf.getOwner()) != null && (double)this.wolf.distanceTo((Entity)owner) < 4.0 && server.getRandom().nextInt(100) < 10) {
            this.wolf.playSound(SoundEvents.WOLF_WHINE, 0.6f, 0.9f + server.getRandom().nextFloat() * 0.2f);
        }
        if (++this.whineTicks >= 300) {
            PetBowlBlockEntity finalBowl;
            if (this.fadeOutTicks < 30) {
                ++this.fadeOutTicks;
                return;
            }
            BlockEntity currentBowl = server.getBlockEntity(this.bowlPos);
            if (currentBowl instanceof PetBowlBlockEntity && (finalBowl = (PetBowlBlockEntity)currentBowl).isEmpty()) {
                this.wolf.playSound(SoundEvents.WOLF_GROWL, 0.4f, 0.4f);
                Vec3 pos = this.wolf.position().add(0.0, 0.5, 0.0);
                server.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y, pos.z, 15, 0.3, 0.3, 0.3, 0.01);
            }
            this.stop();
        }
    }

    public void stop() {
        this.bowlPos = null;
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.active = false;
        this.lastTargetPos = null;
        this.wolf.setOrderedToSit(false);
        if (this.wolf.getNavigation().isInProgress()) {
            this.wolf.getNavigation().stop();
        }
    }

    private void playWhineSound() {
        SoundEvent sound = WHINE_SOUNDS.get(this.wolf.getRandom().nextInt(WHINE_SOUNDS.size()));
        float volume = 0.4f + this.wolf.getRandom().nextFloat() * 0.3f;
        float pitch = 0.4f + this.wolf.getRandom().nextFloat() * 0.4f;
        this.wolf.playSound(sound, volume, pitch);
    }

    private boolean isNearBowl() {
        return this.bowlPos != null && this.wolf.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.bowlPos)) < 1.2100000000000002;
    }

    private boolean shouldScanForBowl(long currentTick) {
        if (currentTick - this.lastScanTick < 40L) {
            return false;
        }
        this.lastScanTick = currentTick;
        return true;
    }

    private boolean isValidWhineTime(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        return dayTime >= 5800L && dayTime <= 6200L || dayTime >= 11500L && dayTime <= 12500L;
    }

    private void moveToBowl(long timeOfDay) {
        if (this.bowlPos != null) {
            Vec3 target = Vec3.atCenterOf((Vec3i)this.bowlPos);
            this.wolf.getNavigation().moveTo(target.x, target.y, target.z, this.getSpeed(timeOfDay));
            this.lastTargetPos = target;
        }
    }

    private boolean needsRepath(Vec3 target) {
        return this.lastTargetPos == null || this.lastTargetPos.distanceToSqr(target) > 0.5;
    }

    private double getSpeed(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        if (dayTime >= 11500L && dayTime <= 12500L) {
            return 0.8;
        }
        return 1.0;
    }
}

