/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.crops.BigCropCapable;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class OnionCropBlock
extends CropBlock
implements BigCropCapable {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    public static final BooleanProperty BIG = BooleanProperty.create((String)"big");
    public static final BooleanProperty GIANT = BooleanProperty.create((String)"giant");

    public OnionCropBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().instabreak().sound(SoundType.CROP).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BIG, (Comparable)Boolean.valueOf(false))).setValue((Property)GIANT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ObjectRegistry.ONION.get();
    }

    @Override
    public int getMaxAge() {
        return 4;
    }

    @Override
    public BooleanProperty getBigProperty() {
        return BIG;
    }

    @Override
    public BooleanProperty getGiantProperty() {
        return GIANT;
    }

    @Override
    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, BIG, GIANT});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.getAge(state) < this.getMaxAge() || (Boolean)state.getValue((Property)BIG) == false || (Boolean)state.getValue((Property)GIANT) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growth;
        int age;
        if (level.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(25.0f / (growth = GeneralUtil.GrowthSpeedUtil.getGrowthSpeed(state, level, pos))) + 1) == 0) {
            level.setBlock(pos, this.getStateForAge(age + 1), 2);
        }
        if (!(((Integer)state.getValue((Property)AGE)).intValue() != this.getMaxAge() || ((Boolean)state.getValue((Property)BIG)).booleanValue() && ((Boolean)state.getValue((Property)GIANT)).booleanValue())) {
            this.tryTransformToBigCrop((Level)level, pos, state, false);
        }
    }
}

