/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.RopeKnotBlock;
import net.satisfy.farm_and_charm.core.block.crops.ClimbingCropBlock;
import org.jetbrains.annotations.NotNull;

public class RopeBlock
extends Block {
    public static final MapCodec<RopeBlock> CODEC = RopeBlock.simpleCodec(RopeBlock::new);
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty CENTER_PIECE = BooleanProperty.create((String)"center_piece");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty SUPPORTING_ROPE_KNOT = BooleanProperty.create((String)"supporting_rope_knot");
    public static final BooleanProperty ROPE_KNOT = BooleanProperty.create((String)"rope_knot");
    private static final VoxelShape CONNECTION_NORTH = Block.box((double)7.0, (double)11.0, (double)0.0, (double)9.0, (double)13.0, (double)7.0);
    private static final VoxelShape CONNECTION_SOUTH = Block.box((double)7.0, (double)11.0, (double)9.0, (double)9.0, (double)13.0, (double)16.0);
    private static final VoxelShape CONNECTION_WEST = Block.box((double)0.0, (double)11.0, (double)7.0, (double)7.0, (double)13.0, (double)9.0);
    private static final VoxelShape CONNECTION_EAST = Block.box((double)9.0, (double)11.0, (double)7.0, (double)16.0, (double)13.0, (double)9.0);
    private static final VoxelShape CONNECTION_KNOT = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    private static final VoxelShape CONNECTION_CENTER = Block.box((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);
    private static final VoxelShape CONNECTION_DOWN = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    private static final VoxelShape CONNECTION_UP = Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape CONNECTION_SUPPORTING_KNOT = Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape BOTTOM_SUPPORT = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)CENTER_PIECE, (Comparable)Boolean.valueOf(false))).setValue((Property)SUPPORTING_ROPE_KNOT, (Comparable)Boolean.valueOf(false))).setValue((Property)ROPE_KNOT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, CENTER_PIECE, SUPPORTING_ROPE_KNOT, ROPE_KNOT});
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        boolean north = this.canConnectTo((LevelAccessor)level, pos.north(), Direction.SOUTH);
        boolean south = this.canConnectTo((LevelAccessor)level, pos.south(), Direction.NORTH);
        boolean east = this.canConnectTo((LevelAccessor)level, pos.east(), Direction.WEST);
        boolean west = this.canConnectTo((LevelAccessor)level, pos.west(), Direction.EAST);
        boolean up = this.canConnectTo((LevelAccessor)level, pos.above(), Direction.DOWN);
        boolean down = this.canConnectTo((LevelAccessor)level, pos.below(), Direction.UP);
        boolean belowClimbingCrop = level.getBlockState(pos.below()).getBlock() instanceof ClimbingCropBlock;
        if (belowClimbingCrop) {
            down = true;
            up = true;
        }
        boolean hasHorizontal = north || south || east || west;
        boolean isCorner = !(!north && !south || !east && !west);
        boolean hasVertical = up || down;
        boolean ropeKnot = hasHorizontal && (isCorner || hasVertical);
        boolean topSupport = level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN);
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)CENTER_PIECE, (Comparable)Boolean.valueOf(true))).setValue((Property)ROPE_KNOT, (Comparable)Boolean.valueOf(ropeKnot))).setValue((Property)SUPPORTING_ROPE_KNOT, (Comparable)Boolean.valueOf(topSupport));
        if (this.hasNoConnection(state)) {
            return null;
        }
        if (!this.hasFixedAnchor((LevelReader)ctx.getLevel(), pos)) {
            return null;
        }
        return state;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction.getAxis().isHorizontal() || direction.getAxis().isVertical()) {
            boolean conn = this.canConnectTo(level, neighborPos, direction.getOpposite());
            state = (BlockState)state.setValue((Property)this.prop(direction), (Comparable)Boolean.valueOf(conn));
            if (direction == Direction.UP) {
                boolean topSupport = neighbor.isFaceSturdy((BlockGetter)level, neighborPos, Direction.DOWN);
                state = (BlockState)state.setValue((Property)SUPPORTING_ROPE_KNOT, (Comparable)Boolean.valueOf(topSupport));
            }
            if (direction == Direction.DOWN && neighbor.getBlock() instanceof ClimbingCropBlock) {
                state = (BlockState)((BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true));
            }
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            boolean east = (Boolean)state.getValue((Property)EAST);
            boolean west = (Boolean)state.getValue((Property)WEST);
            boolean up = (Boolean)state.getValue((Property)UP);
            boolean down = (Boolean)state.getValue((Property)DOWN);
            boolean hasHorizontal = north || south || east || west;
            boolean isCorner = !(!north && !south || !east && !west);
            boolean hasVertical = up || down;
            boolean ropeKnot = hasHorizontal && (isCorner || hasVertical);
            state = (BlockState)state.setValue((Property)ROPE_KNOT, (Comparable)Boolean.valueOf(ropeKnot));
            if (this.hasNoConnection(state = (BlockState)state.setValue((Property)CENTER_PIECE, (Comparable)Boolean.valueOf(true))) || !this.canSurvive(state, (LevelReader)level, pos)) {
                level.scheduleTick(pos, (Block)this, 1);
            }
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.hasNoConnection(state) || !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.hasFixedAnchor(level, pos);
    }

    private boolean hasFixedAnchor(LevelReader level, BlockPos start) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        queue.add(start);
        int steps = 0;
        while (!queue.isEmpty() && steps < 256) {
            BlockPos p = (BlockPos)queue.poll();
            if (!seen.add(p)) continue;
            for (Direction d : Direction.values()) {
                BlockPos n = p.relative(d);
                BlockState s = level.getBlockState(n);
                if (s.getBlock() instanceof RopeKnotBlock) {
                    return true;
                }
                if (s.getBlock() instanceof RopeBlock) {
                    if (seen.contains(n)) continue;
                    queue.add(n);
                    continue;
                }
                if (!(d == Direction.UP ? s.isFaceSturdy((BlockGetter)level, n, Direction.DOWN) : d != Direction.DOWN && s.isFaceSturdy((BlockGetter)level, n, d.getOpposite()))) continue;
                return true;
            }
            ++steps;
        }
        return false;
    }

    private boolean hasNoConnection(BlockState state) {
        return (Boolean)state.getValue((Property)NORTH) == false && (Boolean)state.getValue((Property)SOUTH) == false && (Boolean)state.getValue((Property)EAST) == false && (Boolean)state.getValue((Property)WEST) == false && (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)DOWN) == false;
    }

    private BooleanProperty prop(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            default -> NORTH;
        };
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos neighborPos, Direction dirTowardNeighbor) {
        BlockState blockState = level.getBlockState(neighborPos);
        if (blockState.getBlock() instanceof RopeBlock) {
            return true;
        }
        if (blockState.getBlock() instanceof RopeKnotBlock) {
            return true;
        }
        if (blockState.getBlock() instanceof ClimbingCropBlock) {
            return dirTowardNeighbor == Direction.DOWN || dirTowardNeighbor == Direction.UP;
        }
        if (dirTowardNeighbor == Direction.UP) {
            if (blockState.getBlock() instanceof LanternBlock) {
                return true;
            }
            if (blockState.getBlock() instanceof BellBlock) {
                return true;
            }
            return blockState.isFaceSturdy((BlockGetter)level, neighborPos, Direction.DOWN);
        }
        return blockState.isFaceSturdy((BlockGetter)level, neighborPos, dirTowardNeighbor);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        VoxelShape shape = CONNECTION_CENTER;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_NORTH);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_WEST);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_EAST);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_UP);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_DOWN);
        }
        if (((Boolean)state.getValue((Property)ROPE_KNOT)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_KNOT);
        }
        if (((Boolean)state.getValue((Property)SUPPORTING_ROPE_KNOT)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_SUPPORTING_KNOT);
        }
        return shape;
    }

    @NotNull
    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.or((VoxelShape)this.getShape(state, level, pos, CollisionContext.empty()), (VoxelShape)BOTTOM_SUPPORT);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext ctx) {
        VoxelShape shape = CONNECTION_CENTER;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_NORTH);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_WEST);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_EAST);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_UP);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_DOWN);
        }
        if (((Boolean)state.getValue((Property)ROPE_KNOT)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_KNOT);
        }
        if (((Boolean)state.getValue((Property)SUPPORTING_ROPE_KNOT)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTION_SUPPORTING_KNOT);
        }
        return shape;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

