/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.client.model.WaterSprinklerModel;
import net.satisfy.farm_and_charm.core.block.entity.WaterSprinklerBlockEntity;
import org.joml.Quaternionf;

public class WaterSprinklerRenderer
implements BlockEntityRenderer<WaterSprinklerBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farm_and_charm", (String)"textures/entity/water_sprinkler.png");
    private final ModelPart rotating;
    private final ModelPart basin;
    private long lastRenderTime = 0L;
    private float rotationAngle = 0.0f;

    public WaterSprinklerRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(WaterSprinklerModel.LAYER_LOCATION);
        this.rotating = root.getChild("rotating");
        this.basin = root.getChild("basin");
    }

    private float updateRotationAngle(WaterSprinklerBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        assert (level != null);
        boolean isRaining = level.isRaining();
        boolean isThundering = level.isThundering();
        float rotationSpeed = isRaining || isThundering ? 2.0f : 1.0f;
        long currentTime = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        this.rotationAngle += rotationSpeed * deltaTime * 40.0f;
        this.rotationAngle %= 360.0f;
        blockEntity.setRotationAngle(this.rotationAngle);
        return this.rotationAngle;
    }

    public void render(WaterSprinklerBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        matrixStack.pushPose();
        float angle = this.updateRotationAngle(blockEntity);
        matrixStack.translate(0.5, 0.0, 0.5);
        matrixStack.mulPose(new Quaternionf().rotationY((float)Math.toRadians(-angle)));
        matrixStack.translate(-0.5, 0.0, -0.5);
        this.rotating.render(matrixStack, vertexConsumer, combinedLight, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
        this.basin.render(matrixStack, vertexConsumer, combinedLight, OverlayTexture.NO_OVERLAY);
    }
}

