/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.neoforge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.SynchronizedConfig;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ConfigBuilderImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ForgeConfigHolder
extends ModConfigHolder {
    private static final Map<ModConfig, ForgeConfigHolder> BY_FORGE_CONFIG = new HashMap<ModConfig, ForgeConfigHolder>();
    private final ModConfigSpec spec;
    private final ModConfig modConfig;
    private final List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues;
    private static final Class<?> LOADED_CONFIG_CLASS = (Class)Util.make(() -> {
        try {
            return Class.forName("net.neoforged.fml.config.LoadedConfig");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    });
    private static final Method SET_CONFIG = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfig", (Class[])new Class[]{LOADED_CONFIG_CLASS, Function.class});
    private static final Constructor NEW_LOADED_CONFIG = ObfuscationReflectionHelper.findConstructor(LOADED_CONFIG_CLASS, (Class[])new Class[]{CommentedConfig.class, Path.class, ModConfig.class});
    private static final Method GET_PATH = ObfuscationReflectionHelper.findMethod(LOADED_CONFIG_CLASS, (String)"path", (Class[])new Class[0]);
    private static final Method LOAD_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"loadConfig", (Class[])new Class[]{ModConfig.class, Path.class, Function.class});

    public static ForgeConfigHolder getFromForgeConfig(ModConfig config) {
        return BY_FORGE_CONFIG.get(config);
    }

    ForgeConfigHolder(ResourceLocation name, ModConfigSpec spec, ConfigType type, @Nullable Runnable onChange, List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues) {
        super(name, "toml", FMLPaths.CONFIGDIR.get(), type, onChange);
        this.spec = spec;
        this.specialValues = specialValues;
        ModConfig.Type forgeType = this.getConfigType() == ConfigType.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.COMMON;
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.getModId()).orElseThrow();
        this.modConfig = ConfigTracker.INSTANCE.registerConfig(forgeType, (IConfigSpec)spec, modContainer, this.getFileName());
        IEventBus bus = modContainer.getEventBus();
        if (onChange != null || this.isSynced() || !specialValues.isEmpty()) {
            bus.addListener(this::onConfigChange);
        }
        if (this.isSynced()) {
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
        }
        BY_FORGE_CONFIG.put(this.modConfig, this);
    }

    @Override
    public Path getFullPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getFileName());
    }

    @Override
    public void forceLoad() {
        if (this.isLoaded()) {
            return;
        }
        try {
            LOAD_CONFIG.invoke((Object)ConfigTracker.INSTANCE, this.modConfig, this.getFullPath(), ModConfigEvent.Loading::new);
        }
        catch (Exception e) {
            throw new ModConfigHolder.ConfigLoadingException(this, e);
        }
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent, @Nullable ResourceLocation background) {
        return ModList.get().getModContainerById(this.getModId()).flatMap(container -> container.getCustomExtension(IConfigScreenFactory.class).map(factory -> factory.createScreen(container, parent))).orElse(null);
    }

    @Override
    public boolean hasConfigScreen() {
        return ModList.get().getModContainerById(this.getModId()).map(container -> container.getCustomExtension(IConfigScreenFactory.class).isPresent()).orElse(false);
    }

    @ApiStatus.Internal
    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.syncConfigsToPlayer(serverPlayer);
        }
    }

    @ApiStatus.Internal
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().level().isClientSide) {
            this.onRefresh();
        }
    }

    @ApiStatus.Internal
    public void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.getSpec()) {
            Moonlight.LOGGER.info("Detected config change in {}, from neoforge config event", (Object)this.getFileName());
            if (this.isSynced() && PlatHelper.getPhysicalSide().isServer()) {
                Moonlight.LOGGER.info("Sending changed configs to client", (Object)this.getFileName());
                this.sendSyncedConfigsToAllPlayers();
            }
            this.onRefresh();
            this.specialValues.forEach(ConfigBuilderImpl.ValueWrapper::clearCache);
        }
    }

    @Override
    protected byte[] getConfigFileData() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            CommentedConfig data = this.modConfig.getLoadedConfig().config();
            TomlFormat.instance().createWriter().write((UnmodifiableConfig)data, (OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    @Override
    public void loadFromBytes(InputStream stream, boolean readOnly) {
        if (PlatHelper.isIntegratedServer()) {
            readOnly = false;
        }
        try {
            byte[] b = stream.readAllBytes();
            if (readOnly) {
                ConfigTracker.acceptSyncedConfig((ModConfig)this.modConfig, (byte[])b);
            } else {
                this.acceptEditableConfigs(this.modConfig, b);
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to sync config file {}:", (Object)this.getFileName(), (Object)e);
        }
    }

    public void acceptEditableConfigs(ModConfig modConfig, byte[] bytes) {
        Moonlight.LOGGER.info("Overriding configs {} with synced configs (editable)", (Object)modConfig.getFileName());
        SynchronizedConfig newConfig = new SynchronizedConfig((ConfigFormat)InMemoryCommentedFormat.defaultInstance(), LinkedHashMap::new);
        newConfig.bulkCommentedUpdate(view -> TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes), (Config)view, ParsingMode.REPLACE));
        Path path = this.getFullPath();
        try {
            Object loadedConfig = NEW_LOADED_CONFIG.newInstance(newConfig, path, modConfig);
            SET_CONFIG.invoke((Object)modConfig, loadedConfig, ModConfigEvent.Reloading::new);
            ((IConfigSpec.ILoadedConfig)loadedConfig).save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

