/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.registry.MobEffectRegistry;

public class IntoxicationEffect
extends MobEffect {
    private static final ResourceLocation SPEED_ID = Brewery.identifier("effect.intoxication.speed");
    private static final double BLACKOUT_CHANCE = 0.0015;
    private static final int BLACKOUT_DURATION = 240;

    public IntoxicationEffect() {
        super(MobEffectCategory.HARMFUL, 10251324);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, SPEED_ID, 0.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        int lvl = Math.max(0, amplifier);
        if (lvl >= 5 && !entity.level().isClientSide() && entity.getRandom().nextDouble() < 0.0015) {
            Holder intox = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MobEffectRegistry.DRUNK.get()));
            Holder blackout = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MobEffectRegistry.BLACKOUT.get()));
            entity.removeEffect(intox);
            entity.addEffect(new MobEffectInstance(blackout, 240, 0));
            return true;
        }
        if (lvl > 1) {
            if (entity.level().isClientSide()) {
                float t = (float)entity.tickCount * 0.03f;
                float f = 0.45f + 0.15f * (float)lvl;
                float yaw = Mth.sin((float)(t * f)) * (0.3f + 0.35f * (float)lvl);
                float pitch = Mth.cos((float)(t * (f * 0.85f))) * (0.12f + 0.18f * (float)lvl);
                entity.setYRot(entity.getYRot() + yaw * 0.5f);
                entity.setXRot(Mth.clamp((float)(entity.getXRot() + pitch * 0.5f), (float)-90.0f, (float)90.0f));
                entity.yRotO = Mth.lerp((float)0.6f, (float)entity.yRotO, (float)entity.getYRot());
                entity.xRotO = Mth.lerp((float)0.6f, (float)entity.xRotO, (float)entity.getXRot());
            } else {
                int interval = Math.max(18 - lvl * 2, 6);
                if (entity.tickCount % interval == 0) {
                    double s = 0.01 * (double)lvl;
                    double dx = (entity.getRandom().nextDouble() - 0.5) * s;
                    double dz = (entity.getRandom().nextDouble() - 0.5) * s;
                    entity.push(dx, 0.0, dz);
                }
            }
        }
        if (lvl >= 4 && !entity.level().isClientSide() && entity.tickCount % 40 == 0) {
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0, false, false, false));
        }
        return true;
    }

    public void addAttributeModifiers(AttributeMap attributeMap, int amplifier) {
        AttributeInstance inst = attributeMap.getInstance(Attributes.MOVEMENT_SPEED);
        if (inst != null) {
            double amount;
            inst.removeModifier(SPEED_ID);
            double d = amount = amplifier <= 1 ? 0.0 : -0.05 * (double)(amplifier - 1);
            if (amount != 0.0) {
                inst.addPermanentModifier(new AttributeModifier(SPEED_ID, amount, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
        }
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        AttributeInstance inst = attributeMap.getInstance(Attributes.MOVEMENT_SPEED);
        if (inst != null) {
            inst.removeModifier(SPEED_ID);
        }
    }
}

