/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BrewWhistleBlock
extends BrewingstationBlock {
    public static final BooleanProperty WHISTLE = BlockStateRegistry.WHISTLE;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE;
    public static final Map<Direction, VoxelShape> TOP_SHAPE;
    private static final Supplier<VoxelShape> bottomVoxelShapeSupplier;
    private static final Supplier<VoxelShape> topVoxelShapeSupplier;
    private long lastSoundTime = 0L;

    public BrewWhistleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).setValue((Property)WHISTLE, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlockAndUpdate(blockPos.above(), (BlockState)blockState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return blockState2.is((Block)this) && blockState2.getValue(HALF) != doubleBlockHalf ? (BlockState)blockState.setValue((Property)FACING, (Comparable)((Direction)blockState2.getValue((Property)FACING))) : Blocks.AIR.defaultBlockState();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (((DoubleBlockHalf)blockState.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            blockPos = blockPos.below();
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    @Override
    @NotNull
    public ItemStack getCloneItemStack(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        if (((DoubleBlockHalf)blockState.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            blockPos = blockPos.below();
        }
        return super.getCloneItemStack(blockGetter, blockPos, blockState);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Map<Direction, VoxelShape> shapeMap = state.getValue(HALF) == DoubleBlockHalf.LOWER ? BOTTOM_SHAPE : TOP_SHAPE;
        return shapeMap.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WHISTLE, HALF});
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.getValue((Property)WHISTLE)).booleanValue()) {
            return;
        }
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        double offsetX = 0.5 + (double)direction.getStepX() * 0.6;
        double offsetY = 0.8;
        double offsetZ = 0.5 + (double)direction.getStepZ() * 0.6;
        double x = (double)pos.getX() + offsetX;
        double y = (double)pos.getY() + offsetY;
        double z = (double)pos.getZ() + offsetZ;
        double speedX = (double)direction.getStepX() * 0.1 + ((double)rand.nextFloat() - 0.5) * 0.05;
        double speedY = 0.5;
        double speedZ = (double)direction.getStepZ() * 0.1 + ((double)rand.nextFloat() - 0.5) * 0.05;
        for (int i = 0; i < 5; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, speedX, speedY, speedZ);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSoundTime >= 3000L) {
            world.playLocalSound(x, y, z, (SoundEvent)SoundEventRegistry.BREWSTATION_WHISTLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            this.lastSoundTime = currentTime;
        }
    }

    static {
        bottomVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)1.0, (double)0.125, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.9375, (double)0.125, (double)1.0, (double)1.0, (double)1.0));
            return shape;
        };
        topVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.25, (double)0.4375, (double)1.0, (double)0.5));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.1875, (double)0.5, (double)0.5625, (double)0.5625));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.875, (double)0.1875, (double)0.5, (double)0.9375, (double)0.5625));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.5625, (double)0.5, (double)0.75, (double)0.625));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.15625, (double)0.59375, (double)0.21875, (double)0.46875, (double)0.84375, (double)0.53125));
            return shape;
        };
        BOTTOM_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)bottomVoxelShapeSupplier.get()));
            }
        });
        TOP_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)topVoxelShapeSupplier.get()));
            }
        });
    }
}

