/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.loot.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.CheeseWheelBlock;
import umpaz.brewinandchewin.common.block.PizzaBlock;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class BnCSlicingModifier
extends LootModifier {
    public static final ResourceLocation ID = BrewinAndChewin.asResource("slicing");
    public static final MapCodec<BnCSlicingModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> BnCSlicingModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("slice").forGetter(m -> m.slice)).apply((Applicative)inst, BnCSlicingModifier::new));
    private final Item slice;

    protected BnCSlicingModifier(LootItemCondition[] conditionsIn, Item sliceIn) {
        super(conditionsIn);
        this.slice = sliceIn;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state != null) {
            Block targetBlock = state.getBlock();
            if (targetBlock instanceof PizzaBlock) {
                int servings = (Integer)state.getValue((Property)PizzaBlock.SERVINGS);
                generatedLoot.add((Object)new ItemStack((ItemLike)this.slice, servings + 1));
            } else if (targetBlock instanceof CheeseWheelBlock) {
                int servings = (Integer)state.getValue((Property)CheeseWheelBlock.SERVINGS);
                if (servings == 3 && !((ItemStack)context.getParam(LootContextParams.TOOL)).is(CommonTags.TOOLS_KNIFE)) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)targetBlock.asItem()));
                } else {
                    generatedLoot.add((Object)new ItemStack((ItemLike)this.slice, servings + 1));
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

