/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.container;

import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegFluidItemStorageNeoForge
implements AbstractedFluidTank {
    private final IFluidHandlerItem storage;

    public KegFluidItemStorageNeoForge(ItemStack stack) {
        this.storage = (IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(stack, null);
    }

    @Override
    public long getFluidCapacity() {
        return this.storage.getTankCapacity(0);
    }

    @Override
    public long getFluidCapacity(int slot) {
        return this.storage.getTankCapacity(slot);
    }

    @Override
    public AbstractedFluidStack getAbstractedFluid() {
        FluidStack stack = this.storage.getFluidInTank(0);
        return new AbstractedFluidStack(stack.getFluid(), stack.getAmount(), (DataComponentMap)stack.getComponents(), FluidUnit.MILLIBUCKET, stack);
    }

    @Override
    public void setAbstractedFluid(AbstractedFluidStack stack) {
        this.storage.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        this.storage.fill((FluidStack)stack.loaderSpecific(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public AbstractedFluidStack fill(AbstractedFluidStack stack, boolean simulate) {
        this.storage.fill((FluidStack)stack.loaderSpecific(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return this.getAbstractedFluid();
    }

    @Override
    public AbstractedFluidStack drain(int slot, long maxDrain, FluidUnit unit, boolean simulate) {
        this.storage.drain((int)unit.convertToLoader(maxDrain), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return this.getAbstractedFluid();
    }

    @Override
    public ItemStack getContainer() {
        return this.storage.getContainer();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.getFluidInTank(0).isEmpty();
    }

    @Override
    public boolean isFluidValid(int slot, AbstractedFluidStack stack) {
        IFluidHandlerItem iFluidHandlerItem = this.storage;
        if (iFluidHandlerItem instanceof FluidBucketWrapper) {
            FluidBucketWrapper bucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
            return bucketWrapper.canFillFluidType((FluidStack)stack.loaderSpecific());
        }
        return this.storage.isFluidValid(slot, (FluidStack)stack.loaderSpecific());
    }
}

