/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import vectorwing.farmersdelight.client.gui.HUDOverlays;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class BnCHUDOverlays {
    protected static int foodIconsOffset;
    private static final ResourceLocation NOURISHMENT_ICONS_TEXTURE;
    public static final ResourceLocation FOOD_EMPTY_INTOXICATION_TEXTURE;
    public static final ResourceLocation FOOD_HALF_INTOXICATION_TEXTURE;
    public static final ResourceLocation FOOD_FULL_INTOXICATION_TEXTURE;
    private static final ResourceLocation NAUSEA_LOCATION;
    private static float tipsyTransparencyModifier;

    public static void init(IEventBus modBus) {
        modBus.addListener(EventPriority.LOW, BnCHUDOverlays::register);
        NeoForge.EVENT_BUS.addListener(BnCHUDOverlays::onRenderGuiOverlayPost);
    }

    public static void register(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, TipsyOverlay.ID, (LayeredDraw.Layer)new TipsyOverlay());
        event.registerBelow(VanillaGuiLayers.FOOD_LEVEL, BrewinAndChewin.asResource("food_offset"), (guiGraphics, deltaTracker) -> {
            foodIconsOffset = Minecraft.getInstance().gui.rightHeight;
        });
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, IntoxicationOverlay.ID, (LayeredDraw.Layer)new IntoxicationOverlay());
    }

    public static void onRenderGuiOverlayPost(RenderGuiLayerEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if ((event.getName() == VanillaGuiLayers.FOOD_LEVEL || event.getName() == HUDOverlays.NourishmentOverlay.ID) && ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).intoxicationFoodOverlay() && mc.player.hasEffect(BnCEffects.INTOXICATION)) {
            event.setCanceled(true);
        }
    }

    public static void renderTipsyOverlay(GuiGraphics guiGraphics, float scalar) {
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.setColor(scalar, 0.55f * scalar, 0.08f * scalar, 1.0f);
        guiGraphics.blit(NAUSEA_LOCATION, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void drawIntoxicationOverlay(Player player, Minecraft minecraft, GuiGraphics graphics, int right, int top) {
        int ticks = minecraft.gui.getGuiTicks();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        RenderSystem.enableBlend();
        for (int i = 0; i < 10; ++i) {
            ResourceLocation texture;
            int x = right - i * 8 - 9 + (int)(Mth.cos((float)((float)(ticks + i * 2) * 0.2f)) * 2.0f);
            int y = top + (int)(Mth.sin((float)((float)(ticks + i * 2) * 0.25f)) * 2.0f);
            float effectiveHungerOfBar = (float)player.getFoodData().getFoodLevel() / 2.0f - (float)i;
            ResourceLocation resourceLocation = player.hasEffect(ModEffects.NOURISHMENT) ? NOURISHMENT_ICONS_TEXTURE : (texture = BnCHUDOverlays.getIntoxicationSprite(effectiveHungerOfBar >= 0.5f && effectiveHungerOfBar < 1.0f));
            if (player.hasEffect(ModEffects.NOURISHMENT)) {
                boolean isPlayerHealingWithSaturationAndNourishment = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && player.isHurt() && player.getFoodData().getFoodLevel() >= 18;
                int naturalHealingOffset = isPlayerHealingWithSaturationAndNourishment ? 18 : 0;
                graphics.blit(texture, x, y, 0, 0, 9, 9);
                if (effectiveHungerOfBar >= 1.0f) {
                    graphics.blit(texture, x, y, 18 + naturalHealingOffset, 0, 9, 9);
                    continue;
                }
                if (!(effectiveHungerOfBar >= 0.5f)) continue;
                graphics.blit(texture, x, y, 9 + naturalHealingOffset, 0, 9, 9);
                continue;
            }
            graphics.blitSprite(FOOD_EMPTY_INTOXICATION_TEXTURE, x, y, 9, 9);
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.blitSprite(texture, x, y, 9, 9);
                continue;
            }
            if (!(effectiveHungerOfBar >= 0.5f)) continue;
            graphics.blitSprite(texture, x, y, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    private static ResourceLocation getIntoxicationSprite(boolean half) {
        if (half) {
            return FOOD_HALF_INTOXICATION_TEXTURE;
        }
        return FOOD_FULL_INTOXICATION_TEXTURE;
    }

    static {
        NOURISHMENT_ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"textures/gui/fd_icons.png");
        FOOD_EMPTY_INTOXICATION_TEXTURE = BrewinAndChewin.asResource("hud/food_empty_intoxication");
        FOOD_HALF_INTOXICATION_TEXTURE = BrewinAndChewin.asResource("hud/food_half_intoxication");
        FOOD_FULL_INTOXICATION_TEXTURE = BrewinAndChewin.asResource("hud/food_full_intoxication");
        NAUSEA_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/nausea.png");
        tipsyTransparencyModifier = 0.0f;
    }

    public static class TipsyOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = BrewinAndChewin.asResource("tipsy");

        public void render(GuiGraphics gui, DeltaTracker delta) {
            Minecraft mc = Minecraft.getInstance();
            if (this.shouldRenderOverlay(mc, (Player)mc.player, gui, delta)) {
                MobEffectInstance effect = mc.player.getEffect(BnCEffects.TIPSY);
                float distortionScale = ((Double)mc.options.screenEffectScale().get()).floatValue();
                float tipsyScale = Math.min((float)(1 + effect.getAmplifier()) / 10.0f * 0.4f, 0.4f);
                if (distortionScale < 1.0f && tipsyScale > 0.0f) {
                    BnCHUDOverlays.renderTipsyOverlay(gui, (1.0f - distortionScale) * tipsyScale * tipsyTransparencyModifier);
                    float partialTickModifier = delta.getGameTimeDeltaTicks() * (effect.endsWithin(60) ? -0.006f : 0.007f);
                    tipsyTransparencyModifier = Mth.clamp((float)(tipsyTransparencyModifier + partialTickModifier), (float)0.0f, (float)1.0f);
                } else {
                    tipsyTransparencyModifier = 0.0f;
                }
            } else {
                tipsyTransparencyModifier = 0.0f;
            }
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft minecraft, Player player, GuiGraphics gui, DeltaTracker delta) {
            return super.shouldRenderOverlay(minecraft, player, gui, delta) && !player.hasEffect(MobEffects.CONFUSION) && player.hasEffect(BnCEffects.TIPSY);
        }
    }

    public static class IntoxicationOverlay
    extends BaseOverlay {
        public static final ResourceLocation ID = BrewinAndChewin.asResource("intoxication");

        public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
            LocalPlayer player;
            if (!((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).intoxicationFoodOverlay()) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            if (!this.shouldRenderOverlay(minecraft, (Player)(player = minecraft.player), gui, deltaTracker)) {
                return;
            }
            int top = minecraft.getWindow().getGuiScaledHeight() - foodIconsOffset;
            int right = minecraft.getWindow().getGuiScaledWidth() / 2 + 91;
            BnCHUDOverlays.drawIntoxicationOverlay((Player)player, minecraft, gui, right, top);
            minecraft.gui.rightHeight += 10;
        }

        @Override
        public boolean shouldRenderOverlay(Minecraft minecraft, Player player, GuiGraphics guiGraphics, DeltaTracker guiTicks) {
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks) && player != null && player.hasEffect(BnCEffects.INTOXICATION);
        }
    }

    public static abstract class BaseOverlay
    implements LayeredDraw.Layer {
        public boolean shouldRenderOverlay(Minecraft minecraft, Player player, GuiGraphics gui, DeltaTracker delta) {
            return !minecraft.options.hideGui && minecraft.gameMode != null && minecraft.gameMode.canHurtPlayer();
        }
    }
}

