/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.BnCClientSetup;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.client.gui.KegTooltip;
import umpaz.brewinandchewin.client.renderer.CoasterBlockEntityRenderer;
import umpaz.brewinandchewin.common.fluid.BnCFluidConstants;
import umpaz.brewinandchewin.common.mixin.client.ModelBakeryAccessor;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.neoforge.client.gui.BnCHUDOverlays;
import umpaz.brewinandchewin.neoforge.client.model.CoasterWrappedModel;
import umpaz.brewinandchewin.neoforge.client.platform.BnCClientPlatfomHelperNeoForge;
import umpaz.brewinandchewin.neoforge.registry.BnCFluidTypes;

@Mod(value="brewinandchewin", dist={Dist.CLIENT})
public class BrewinAndChewinNeoForgeClient {
    public BrewinAndChewinNeoForgeClient(IEventBus eventBus) {
        BrewinAndChewinClient.init(new BnCClientPlatfomHelperNeoForge());
        BnCHUDOverlays.init(eventBus);
        BrewinAndChewin.isClient = true;
    }

    @EventBusSubscriber(modid="brewinandchewin", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        private static final List<ResourceLocation> MODELS = new ArrayList<ResourceLocation>();

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register(BnCMenuTypes.KEG, KegScreen::new);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerFluidType(ModEvents.createHoneyExtension(-1), new FluidType[]{BnCFluidTypes.HONEY});
            event.registerFluidType(ModEvents.createAlcoholExtension(-282345), new FluidType[]{BnCFluidTypes.BEER});
            event.registerFluidType(ModEvents.createAlcoholExtension(-1573386), new FluidType[]{BnCFluidTypes.VODKA});
            event.registerFluidType(ModEvents.createHoneyExtension(-11475), new FluidType[]{BnCFluidTypes.MEAD});
            event.registerFluidType(ModEvents.createAlcoholExtension(-1), new FluidType[]{BnCFluidTypes.EGG_GROG});
            event.registerFluidType(ModEvents.createAlcoholExtension(-4437425), new FluidType[]{BnCFluidTypes.STRONGROOT_ALE});
            event.registerFluidType(ModEvents.createAlcoholExtension(-1), new FluidType[]{BnCFluidTypes.RICE_WINE});
            event.registerFluidType(ModEvents.createAlcoholExtension(-678562), new FluidType[]{BnCFluidTypes.GLITTERING_GRENADINE});
            event.registerFluidType(ModEvents.createAlcoholExtension(-6845556), new FluidType[]{BnCFluidTypes.STEEL_TOE_STOUT});
            event.registerFluidType(ModEvents.createAlcoholExtension(-14296393), new FluidType[]{BnCFluidTypes.DREAD_NOG});
            event.registerFluidType(ModEvents.createAlcoholExtension(-7171528), new FluidType[]{BnCFluidTypes.KOMBUCHA});
            event.registerFluidType(ModEvents.createAlcoholExtension(-3323270), new FluidType[]{BnCFluidTypes.SACCHARINE_RUM});
            event.registerFluidType(ModEvents.createAlcoholExtension(-2572629), new FluidType[]{BnCFluidTypes.PALE_JANE});
            event.registerFluidType(ModEvents.createAlcoholExtension(-13080787), new FluidType[]{BnCFluidTypes.SALTY_FOLLY});
            event.registerFluidType(ModEvents.createAlcoholExtension(-8120819), new FluidType[]{BnCFluidTypes.BLOODY_MARY});
            event.registerFluidType(ModEvents.createAlcoholExtension(-11397104), new FluidType[]{BnCFluidTypes.RED_RUM});
            event.registerFluidType(ModEvents.createAlcoholExtension(-15133679), new FluidType[]{BnCFluidTypes.WITHERING_DROSS});
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return BnCFluidConstants.Textures.FLAXEN_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return BnCFluidConstants.Textures.FLAXEN_FLOWING_TEXTURE;
                }
            }, new FluidType[]{BnCFluidTypes.FLAXEN_CHEESE});
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return BnCFluidConstants.Textures.SCARLET_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return BnCFluidConstants.Textures.SCARLET_FLOWING_TEXTURE;
                }
            }, new FluidType[]{BnCFluidTypes.SCARLET_CHEESE});
        }

        private static IClientFluidTypeExtensions createHoneyExtension(final int color) {
            return new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return BnCFluidConstants.Textures.HONEY_FLUID_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return BnCFluidConstants.Textures.HONEY_FLUID_FLOWING_TEXTURE;
                }

                public int getTintColor() {
                    return color;
                }
            };
        }

        private static IClientFluidTypeExtensions createAlcoholExtension(final int color) {
            return new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return BnCFluidConstants.Textures.FLUID_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return BnCFluidConstants.Textures.FLUID_FLOWING_TEXTURE;
                }

                public int getTintColor() {
                    return color;
                }
            };
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            BnCClientSetup.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            BnCClientSetup.registerParticles((arg_0, arg_1) -> ((RegisterParticleProvidersEvent)event).registerSpriteSet(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void registerKegTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(KegTooltip.KegTooltipComponent.class, KegTooltip::new);
        }

        @SubscribeEvent
        public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
            BnCClientSetup.registerReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
        }

        @SubscribeEvent
        public static void registerColorHandlers(RegisterColorHandlersEvent.Block event) {
            BnCClientSetup.registerColorHandlers((BlockColor x$0, Block xva$1) -> event.register(x$0, new Block[]{xva$1}));
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            CoasterBlockEntityRenderer.resetCache();
            MODELS.addAll((Collection<ResourceLocation>)BnCClientSetup.getModels(Minecraft.getInstance().getResourceManager(), Runnable::run).join());
            event.register(ModelResourceLocation.standalone((ResourceLocation)BrewinAndChewin.asResource("block/coaster")));
            event.register(ModelResourceLocation.standalone((ResourceLocation)BrewinAndChewin.asResource("block/coaster_tray")));
        }

        @SubscribeEvent
        public static void modifyBakingResult(ModelEvent.ModifyBakingResult event) {
            for (ResourceLocation entry : MODELS) {
                event.getModels().put(ModelResourceLocation.standalone((ResourceLocation)entry.withPath(path -> "brewinandchewin/coaster/" + path)), new CoasterWrappedModel(ModEvents.bakeModel(event, entry)));
            }
            MODELS.clear();
        }

        private static BakedModel bakeModel(ModelEvent.ModifyBakingResult event, ResourceLocation path) {
            UnbakedModel unbaked = ((ModelBakeryAccessor)event.getModelBakery()).brewinandchewin$getModel(path);
            unbaked.resolveParents(location -> ((ModelBakeryAccessor)event.getModelBakery()).brewinandchewin$getModel((ResourceLocation)location));
            ModelResourceLocation modelResource = ModelResourceLocation.standalone((ResourceLocation)path);
            return unbaked.bake((ModelBaker)new ModelBakery.ModelBakerImpl(event.getModelBakery(), (rl, material) -> material.sprite(), modelResource), event.getTextureGetter(), (ModelState)BlockModelRotation.X0_Y0);
        }
    }
}

