/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;

public class FermentingTransferServer {
    public static void setItems(Player player, KegFermentingRecipe recipe, FermentingTransfer.TransferOperations transferOperations, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean maxTransfer) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof KegMenu)) {
            return;
        }
        KegMenu kegMenu = (KegMenu)abstractContainerMenu;
        Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack = FermentingTransferServer.calculateRequiredStacks(transferOperations, player);
        List<Pair<Slot, Pair<ItemStack, Long>>> requiredFluidStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.fluidResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.left((Object)recipe));
        List<Pair<Slot, Pair<ItemStack, Long>>> requiredEmptyingStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.emptyingResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.right((Object)((Object)kegMenu)));
        if (recipeSlotToRequiredItemStack == null || requiredFluidStacks == null || requiredEmptyingStacks == null) {
            return;
        }
        boolean transferAsCompleteSets = !maxTransfer;
        Map<Slot, ItemStack> recipeSlotToTakenStacks = FermentingTransferServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        List<ItemStack> emptyingSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredEmptyingStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, false);
        List<ItemStack> fluidSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredFluidStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, true);
        if (recipeSlotToTakenStacks.isEmpty() && fluidSlotToTakenStacks.isEmpty() && emptyingSlotToTakenStacks.isEmpty()) {
            return;
        }
        boolean sameFluid = recipe.getFluidIngredient().isEmpty() && kegMenu.kegTank.isEmpty() || recipe.getFluidIngredient().isPresent() && recipe.getFluidIngredient().get().ingredient().matches(kegMenu.kegTank.getAbstractedFluid());
        List<ItemStack> clearedFluidItems = FermentingTransferServer.extractFromFluidTank(player.level(), emptyingSlotToTakenStacks, kegMenu, false, null);
        if (sameFluid && !maxTransfer) {
            fluidSlotToTakenStacks = clearedFluidItems;
        } else {
            FermentingTransferServer.stowItems(player, inventorySlots, clearedFluidItems);
        }
        List<ItemStack> fluidItems = FermentingTransferServer.extractFromFluidTank(player.level(), fluidSlotToTakenStacks, kegMenu, true, !maxTransfer ? recipe : null);
        List<ItemStack> clearedCraftingItems = FermentingTransferServer.clearCraftingGrid(craftingSlots, player);
        List<ItemStack> remainderItems = FermentingTransferServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks);
        FermentingTransferServer.stowItems(player, inventorySlots, fluidItems);
        FermentingTransferServer.stowItems(player, inventorySlots, clearedCraftingItems);
        FermentingTransferServer.stowItems(player, inventorySlots, remainderItems);
        kegMenu.blockEntity.setChanged();
        player.level().sendBlockUpdated(kegMenu.blockEntity.getBlockPos(), kegMenu.blockEntity.getBlockState(), kegMenu.blockEntity.getBlockState(), 2);
    }

    @NotNull
    private static Map<Slot, ItemStack> takeItemsFromInventory(Player player, Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<Slot, ItemStack> foundItemsInSet;
        if (!maxTransfer) {
            return FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<Slot, ItemStack> recipeSlotToResult = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<Slot> fullSlots = FermentingTransferServer.merge(recipeSlotToResult, foundItemsInSet);
            for (Slot fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<Slot, ItemStack> removeOneSetOfItemsFromInventory(Player player, Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        HashMap<Slot, ItemStack> foundItemsInSet = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<Slot, Pair<Slot, ItemStack>> entry : recipeSlotToRequiredItemStack.entrySet()) {
            Slot hint;
            Slot recipeSlot = entry.getKey();
            ItemStack requiredStack = (ItemStack)entry.getValue().getSecond();
            Slot slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (Slot)entry.getValue().getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.getItem().copy());
                }
                ItemStack removedItemStack = slot.remove(1);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                ((Slot)slotEntry.getKey()).set(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    @NotNull
    private static List<ItemStack> takeFluidOrEmptyingItemsFromInventory(Player player, KegMenu kegMenu, List<Pair<Slot, Pair<ItemStack, Long>>> requiredItemStacks, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer, boolean insert) {
        Pair<List<ItemStack>, Integer> foundItemsInSet;
        if (!maxTransfer) {
            return (List)FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets).getFirst();
        }
        ArrayList<ItemStack> recipeSlotToResult = new ArrayList<ItemStack>(requiredItemStacks.size());
        int fluidCapacity = 0;
        while (!(insert && (long)fluidCapacity >= kegMenu.kegTank.getFluidCapacity() || !insert && (long)fluidCapacity >= kegMenu.kegTank.getAbstractedFluid().amount() || ((List)(foundItemsInSet = FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets)).getFirst()).isEmpty())) {
            fluidCapacity += ((Integer)foundItemsInSet.getSecond()).intValue();
            recipeSlotToResult.addAll((Collection)foundItemsInSet.getFirst());
        }
        return recipeSlotToResult;
    }

    private static Pair<List<ItemStack>, Integer> removeOneSetOfFluidOrEmptyingItemsFromInventory(Player player, List<Pair<Slot, Pair<ItemStack, Long>>> requiredItemStacks, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        ArrayList<ItemStack> foundItemsInSet = new ArrayList<ItemStack>(requiredItemStacks.size());
        int fluidAmount = 0;
        for (Pair<Slot, Pair<ItemStack, Long>> entry : requiredItemStacks) {
            Slot hint;
            ItemStack requiredStack = (ItemStack)((Pair)entry.getSecond()).getFirst();
            Slot slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (Slot)entry.getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.getItem().copy());
                }
                ItemStack removedItemStack = slot.remove(requiredStack.getCount());
                foundItemsInSet.add(removedItemStack);
                fluidAmount = (int)((long)fluidAmount + (Long)((Pair)entry.getSecond()).getSecond());
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                ((Slot)slotEntry.getKey()).set(stack);
            }
            return Pair.of(List.of(), (Object)0);
        }
        return Pair.of(foundItemsInSet, (Object)fluidAmount);
    }

    private static Set<Slot> merge(Map<Slot, ItemStack> result, Map<Slot, ItemStack> addition) {
        HashSet<Slot> fullSlots = new HashSet<Slot>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.getCount() == 1);
            ItemStack resultItemStack = (ItemStack)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((Slot)slot, resultItemStack);
            } else {
                assert (ItemStack.isSameItemSameComponents((ItemStack)resultItemStack, (ItemStack)itemStack));
                resultItemStack.grow(itemStack.getCount());
            }
            if (resultItemStack.getCount() == slot.getMaxStackSize(resultItemStack)) {
                fullSlots.add((Slot)slot);
            }
        });
        return fullSlots;
    }

    @Nullable
    private static Map<Slot, Pair<Slot, ItemStack>> calculateRequiredStacks(FermentingTransfer.TransferOperations transferOperations, Player player) {
        HashMap<Slot, Pair<Slot, ItemStack>> recipeSlotToRequired = new HashMap<Slot, Pair<Slot, ItemStack>>(transferOperations.results.size());
        for (Pair<Slot, Slot> transferOperation : transferOperations.results) {
            Slot recipeSlot = (Slot)transferOperation.getSecond();
            Slot inventorySlot = (Slot)transferOperation.getFirst();
            if (!inventorySlot.mayPickup(player)) {
                return null;
            }
            ItemStack slotStack = inventorySlot.getItem();
            if (slotStack.isEmpty()) {
                return null;
            }
            ItemStack stack = slotStack.copy();
            stack.setCount(1);
            recipeSlotToRequired.put(recipeSlot, (Pair<Slot, ItemStack>)Pair.of((Object)inventorySlot, (Object)stack));
        }
        return recipeSlotToRequired;
    }

    @Nullable
    private static List<Pair<Slot, Pair<ItemStack, Long>>> calculateRequiredFluidOrEmptyingStacks(List<Pair<Slot, Long>> slots, Player player, Either<KegFermentingRecipe, KegMenu> pouringRecipeSource) {
        if (pouringRecipeSource.left().isPresent() && ((KegFermentingRecipe)pouringRecipeSource.left().get()).getFluidIngredient().isEmpty()) {
            return List.of();
        }
        ArrayList<Pair<Slot, Pair<ItemStack, Long>>> recipeSlotToRequired = new ArrayList<Pair<Slot, Pair<ItemStack, Long>>>(slots.size());
        for (Pair<Slot, Long> inventorySlot : slots) {
            if (!((Slot)inventorySlot.getFirst()).mayPickup(player)) {
                return null;
            }
            ItemStack slotStack = ((Slot)inventorySlot.getFirst()).getItem();
            if (slotStack.isEmpty()) {
                return null;
            }
            ItemStack stack = slotStack.copy();
            int fluidStackAmount = 1;
            List<KegPouringRecipe> pouringRecipes = player.level().getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> (pouringRecipeSource.left().isEmpty() || kegPouringRecipe.canFill()) && (Boolean)pouringRecipeSource.map(recipe -> recipe.getFluidIngredient().orElseThrow().ingredient().matches(kegPouringRecipe.getFluid(stack)), menu -> menu.kegTank.getAbstractedFluid().matches(kegPouringRecipe.getFluid(stack))) != false).toList();
            Optional<KegPouringRecipe> optionalData = pouringRecipes.stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
                }
                return ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
            }).findFirst();
            if (optionalData.isPresent()) {
                fluidStackAmount = (int)((Long)pouringRecipeSource.map(fermentingRecipe -> fermentingRecipe.getFluidIngredient().orElseThrow().amount(), kegMenu -> kegMenu.kegTank.getAbstractedFluid().amount()) / optionalData.get().getRawFluid().amount());
            }
            stack.setCount(fluidStackAmount);
            recipeSlotToRequired.add((Pair<Slot, Pair<ItemStack, Long>>)Pair.of((Object)((Slot)inventorySlot.getFirst()), (Object)Pair.of((Object)stack, (Object)((Long)inventorySlot.getSecond()))));
        }
        return recipeSlotToRequired;
    }

    private static void stowItems(Player player, List<Slot> inventorySlots, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            ItemStack remainder = FermentingTransferServer.stowItem(inventorySlots, itemStack);
            if (remainder.isEmpty() || player.getInventory().add(remainder)) continue;
            player.drop(remainder, false);
        }
    }

    private static List<ItemStack> extractFromFluidTank(Level level, List<ItemStack> emptyingStacks, KegMenu kegMenu, boolean insert, @Nullable KegFermentingRecipe recipe) {
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        if (insert && (recipe == null || recipe.getFluidIngredient().isEmpty())) {
            return remainderItems;
        }
        KegBlockEntity blockEntity = kegMenu.blockEntity;
        for (ItemStack stack : emptyingStacks) {
            List<KegPouringRecipe> pouringRecipes;
            Optional<KegPouringRecipe> optionalData;
            if (insert && kegMenu.kegTank.getAbstractedFluid().amount() >= recipe.getFluidIngredient().orElseThrow().amount() || !insert && kegMenu.kegTank.isEmpty()) break;
            int toExtract = stack.getCount();
            if (recipe != null && recipe.getFluidIngredient().isPresent() && (optionalData = (pouringRecipes = level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> (!insert || kegPouringRecipe.canFill()) && recipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getFluid(stack))).toList()).stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)pouring.getOutput());
                }
                return ItemStack.isSameItem((ItemStack)stack, (ItemStack)pouring.getOutput());
            }).findFirst()).isPresent()) {
                toExtract = (int)(recipe.getFluidIngredient().get().amount() / optionalData.get().getRawFluid().amount());
            }
            List<ItemStack> extracted = blockEntity.extractInGui(stack, toExtract);
            for (ItemStack extract : extracted) {
                if (extract.isEmpty()) continue;
                remainderItems.add(extract);
            }
        }
        return remainderItems;
    }

    private static List<ItemStack> clearCraftingGrid(List<Slot> craftingSlots, Player player) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Slot craftingSlot : craftingSlots) {
            if (!craftingSlot.mayPickup(player) || !craftingSlot.hasItem()) continue;
            ItemStack craftingItem = craftingSlot.remove(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<ItemStack> putItemsIntoCraftingGrid(Map<Slot, ItemStack> recipeSlotToTakenStacks) {
        int slotStackLimit = FermentingTransferServer.getSlotStackLimit(recipeSlotToTakenStacks);
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            if (slot.getItem().isEmpty() && slot.mayPlace(stack)) {
                ItemStack remainder = slot.safeInsert(stack, slotStackLimit);
                if (!remainder.isEmpty()) {
                    remainderItems.add(remainder);
                }
            } else {
                remainderItems.add((ItemStack)stack);
            }
        });
        return remainderItems;
    }

    private static int getSlotStackLimit(Map<Slot, ItemStack> recipeSlotToTakenStacks) {
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            ItemStack transferItem;
            Slot craftingSlot = (Slot)e.getKey();
            if (craftingSlot.mayPlace(transferItem = (ItemStack)e.getValue())) {
                return craftingSlot.getMaxStackSize(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static ItemStack stowItem(Collection<Slot> slots, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = stack.copy();
        for (Slot slot : slots) {
            ItemStack inventoryStack = slot.getItem();
            if (inventoryStack.isEmpty() || !inventoryStack.isStackable()) continue;
            slot.safeInsert(remainder);
            if (!remainder.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (Slot slot : slots) {
            if (!slot.getItem().isEmpty()) continue;
            slot.safeInsert(remainder);
            if (!remainder.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remainder;
    }

    private static Optional<Slot> getSlotWithStack(Player player, ItemStack stack, List<Slot> craftingSlots, List<Slot> inventorySlots, Slot hint) {
        return FermentingTransferServer.getSlotWithStack(player, craftingSlots, stack).or(() -> FermentingTransferServer.getValidatedHintSlot(player, stack, hint)).or(() -> FermentingTransferServer.getSlotWithStack(player, inventorySlots, stack));
    }

    private static Optional<Slot> getValidatedHintSlot(Player player, ItemStack stack, Slot hint) {
        if (hint.mayPickup(player) && !hint.getItem().isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)hint.getItem())) {
            return Optional.of(hint);
        }
        return Optional.empty();
    }

    private static Optional<Slot> getSlotWithStack(Player player, Collection<Slot> slots, ItemStack itemStack) {
        return slots.stream().filter(slot -> {
            ItemStack slotStack = slot.getItem();
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)slotStack) && slot.mayPickup(player);
        }).findFirst();
    }
}

