/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.KegEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.PouringEmiRecipe;

public class BnCEMIRecipeFiller {
    @Nullable
    public static Map<KegEmiRecipeHandler.InputType, List<ItemStack>> getFermentingStacks(KegEmiRecipeHandler handler, FermentingEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount) {
        try {
            KegMenu menu = (KegMenu)context.getScreen().getMenu();
            if (handler != null) {
                HashMap desired = Maps.newHashMap();
                List<Slot> slots = handler.getInputSources(menu);
                List<Slot> craftingSlots = handler.getCraftingSlots(menu);
                List<EmiIngredient> itemIngredients = recipe.getItemInputs();
                EmiIngredient fluidIngredient = recipe.getFluidInput();
                EmiIngredient fluidItemIngredient = recipe.getFluidItemInput();
                EmiIngredient emptyingIngredient = KegEmiRecipeHandler.getEmptyingIngredient(recipe, context);
                if (!BnCEMIRecipeFiller.handleItemInputs(handler, recipe, (AbstractContainerScreen<KegMenu>)context.getScreen(), amount, desired, itemIngredients, slots, craftingSlots)) {
                    return null;
                }
                if (fluidItemIngredient != null && !BnCEMIRecipeFiller.handleFillingInputs(handler, recipe, context, amount, desired, fluidIngredient, fluidItemIngredient, slots)) {
                    return null;
                }
                if (emptyingIngredient != null && !((KegMenu)context.getScreen().getMenu()).kegTank.isEmpty() && !BnCEMIRecipeFiller.handleEmptyingInputs(handler, recipe, context, amount, desired, emptyingIngredient, slots)) {
                    return null;
                }
                return desired;
            }
        }
        catch (Exception ex) {
            BrewinAndChewin.LOG.error("Failed to get fermenting recipe stacks. ", (Throwable)ex);
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> getPouringStacks(KegEmiRecipeHandler handler, PouringEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount) {
        try {
            KegMenu menu = (KegMenu)context.getScreen().getMenu();
            if (handler != null) {
                HashMap desired = Maps.newHashMap();
                List<Slot> slots = handler.getInputSources(menu);
                EmiIngredient emptyingIngredient = recipe.getItemInputs().getFirst();
                if (emptyingIngredient != null && !((KegMenu)context.getScreen().getMenu()).kegTank.isEmpty() && !BnCEMIRecipeFiller.handleEmptyingInputs(handler, recipe, context, amount, desired, emptyingIngredient, slots)) {
                    return null;
                }
                return (List)desired.get((Object)KegEmiRecipeHandler.InputType.EMPTY);
            }
        }
        catch (Exception ex) {
            BrewinAndChewin.LOG.error("Failed to get fermenting recipe stacks. ", (Throwable)ex);
        }
        return null;
    }

    private static boolean handleItemInputs(KegEmiRecipeHandler handler, EmiRecipe recipe, AbstractContainerScreen<KegMenu> screen, int amount, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> desired, List<EmiIngredient> ingredients, List<Slot> slots, List<Slot> craftingSlots) {
        Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
        ArrayList discovered = Lists.newArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            Object stack;
            ArrayList d = Lists.newArrayList();
            EmiIngredient ingredient = ingredients.get(i);
            List emiStacks = ingredient.getEmiStacks();
            if (ingredient.isEmpty()) {
                discovered.add(null);
                continue;
            }
            Iterator iterator = emiStacks.iterator();
            while (iterator.hasNext()) {
                stack = (EmiStack)iterator.next();
                block2: for (Slot s : slots) {
                    ItemStack ss = s.getItem();
                    if (!EmiStack.of((ItemStack)s.getItem()).isEqual((EmiStack)stack)) continue;
                    Iterator iterator2 = d.iterator();
                    while (iterator2.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)iterator2.next();
                        if (!ItemStack.isSameItemSameComponents((ItemStack)ss, (ItemStack)di.stack)) continue;
                        di.amount += ss.getCount();
                        continue block2;
                    }
                    d.add(new DiscoveredItem((EmiStack)stack, ss, ss.getCount(), (int)ingredient.getAmount(), ss.getMaxStackSize()));
                }
            }
            DiscoveredItem biggest = null;
            stack = d.iterator();
            while (stack.hasNext()) {
                DiscoveredItem di = (DiscoveredItem)stack.next();
                if (biggest == null) {
                    biggest = di;
                    continue;
                }
                int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                if (ba >= a) continue;
                biggest = di;
            }
            if (biggest == null || i >= craftingSlots.size()) {
                return false;
            }
            Slot slot = craftingSlots.get(i);
            if (slot == null) {
                return false;
            }
            weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
            biggest.max = Math.min(biggest.max, slot.getMaxStackSize());
            discovered.add(biggest);
        }
        if (discovered.isEmpty()) {
            return false;
        }
        ArrayList unique = Lists.newArrayList();
        block5: for (DiscoveredItem di : discovered) {
            if (di == null) continue;
            for (DiscoveredItem ui : unique) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)di.stack, (ItemStack)ui.stack)) continue;
                ui.consumed += di.consumed;
                continue block5;
            }
            unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max));
        }
        int maxAmount = Integer.MAX_VALUE;
        for (DiscoveredItem ui : unique) {
            if (ui.catalyst()) continue;
            maxAmount = Math.min(maxAmount, ui.amount / ui.consumed);
            maxAmount = Math.min(maxAmount, ui.max);
        }
        if ((maxAmount = Math.min(maxAmount, amount + BnCEMIRecipeFiller.batchesAlreadyPresent(recipe, handler, screen))) == 0) {
            return false;
        }
        for (DiscoveredItem di : discovered) {
            if (di != null) {
                ItemStack is = di.stack.copy();
                int a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                is.setCount(a);
                desired.computeIfAbsent(KegEmiRecipeHandler.InputType.ITEM, inputType -> new ArrayList()).add(is);
                continue;
            }
            desired.computeIfAbsent(KegEmiRecipeHandler.InputType.ITEM, inputType -> new ArrayList()).add(ItemStack.EMPTY);
        }
        return true;
    }

    private static boolean handleFillingInputs(KegEmiRecipeHandler handler, FermentingEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> desired, EmiIngredient fluidIngredient, EmiIngredient itemIngredient, List<Slot> slots) {
        if (recipe.getFluidInput() == null || fluidIngredient.getEmiStacks().stream().anyMatch(emiStack -> ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().matches(new AbstractedFluidStack((Fluid)emiStack.getKey(), (int)emiStack.getAmount(), (DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)emiStack.getComponentChanges())))) && ((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() == Math.min(fluidIngredient.getAmount() * (long)context.getAmount(), ((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity())) {
            return true;
        }
        EmiIngredient emiFluidIngredient = recipe.getFluidInput();
        EmiStack emiFluidStack = (EmiStack)recipe.getFluidInput().getEmiStacks().getFirst();
        AbstractedFluidStack fluidStack = new AbstractedFluidStack((Fluid)emiFluidStack.getKey(), (int)emiFluidStack.getAmount(), (DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)emiFluidStack.getComponentChanges()), FluidUnit.getLoaderUnit());
        ArrayList discoveredQuickRef = Lists.newArrayList();
        ArrayList d = Lists.newArrayList();
        List emiStacks = itemIngredient.getEmiStacks();
        for (EmiStack stack : emiStacks) {
            block1: for (Slot s : slots) {
                ItemStack ss = s.getItem();
                if (!EmiStack.of((ItemStack)s.getItem()).isEqual(stack)) continue;
                for (DiscoveredItem di : d) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)ss, (ItemStack)di.stack) && di.amount < di.consumed) continue;
                    di.amount += ss.getCount();
                    continue block1;
                }
                Optional<PouringEmiRecipe> potentialPouring = EmiApi.getRecipeManager().getRecipes(BnCRecipeCategories.POURING).stream().filter(r -> {
                    if (!(r instanceof PouringEmiRecipe)) {
                        return false;
                    }
                    PouringEmiRecipe pouring = (PouringEmiRecipe)r;
                    if (recipe.getFluidInput() == null) {
                        return false;
                    }
                    return emiFluidIngredient.getEmiStacks().stream().anyMatch(es -> ((EmiStack)pouring.getFluidInput().getEmiStacks().getFirst()).isEqual(es)) && ((EmiStack)r.getOutputs().getFirst()).isEqual(stack);
                }).map(recipe1 -> (PouringEmiRecipe)recipe1).findFirst();
                if (!potentialPouring.isPresent()) continue;
                AbstractedFluidStack tankStack = ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid();
                EmiStack tankEmiStack = EmiStack.of((Fluid)tankStack.fluid(), (DataComponentPatch)tankStack.componentPatch(), (long)tankStack.amount());
                int consumed = (int)((((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() - (potentialPouring.get().getFluidInput().getEmiStacks().stream().anyMatch(emiStack -> emiStack.isEqual(tankEmiStack)) ? ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().amount() : 0L)) / potentialPouring.get().getFluidInput().getAmount());
                if (consumed < 1) continue;
                d.add(new DiscoveredItem(stack, ss, ss.getCount(), consumed, (int)stack.getAmount()));
                discoveredQuickRef.add(stack);
            }
        }
        for (EmiStack inventoryStack : context.getInventory().inventory.values()) {
            if (discoveredQuickRef.contains(inventoryStack)) continue;
            ItemStack itemStack = inventoryStack.getItemStack();
            AbstractedFluidTank tank = BrewinAndChewin.getHelper().getFluidContainerFromItem(itemStack);
            if (tank == null) continue;
            int target = (int)tank.getAbstractedFluid().amount();
            if (!tank.getAbstractedFluid().isEmpty() || !tank.isFluidValid(0, fluidStack) || target <= 0) continue;
            AbstractedFluidStack tankStack = ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid();
            int consumed = (int)((((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() - (tankStack.matches(tank.getAbstractedFluid()) ? ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().amount() : 0L)) / (long)target);
            if (consumed < 1) continue;
            d.add(new DiscoveredItem(inventoryStack, itemStack, itemStack.getCount(), consumed, (int)(((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() / (long)target)));
        }
        return BnCEMIRecipeFiller.handleFluidInternally(handler, recipe, context, amount, KegEmiRecipeHandler.InputType.FILL, desired, d);
    }

    private static boolean handleEmptyingInputs(KegEmiRecipeHandler handler, KegEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> desired, EmiIngredient ingredient, List<Slot> slots) {
        if (((KegMenu)context.getScreen().getMenu()).kegTank.isEmpty()) {
            return true;
        }
        AbstractedFluidStack fluidStack = ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid();
        EmiStack emiFluidStack = EmiStack.of((Fluid)fluidStack.fluid(), (DataComponentPatch)fluidStack.componentPatch(), (long)fluidStack.amount());
        ArrayList discoveredQuickRef = Lists.newArrayList();
        ArrayList d = Lists.newArrayList();
        List emiStacks = ingredient.getEmiStacks();
        for (EmiStack stack : emiStacks) {
            block1: for (Slot s : slots) {
                Optional<PouringEmiRecipe> potentialPouring;
                Optional<PouringEmiRecipe> optional;
                ItemStack ss = s.getItem();
                if (!EmiStack.of((ItemStack)s.getItem()).isEqual(stack)) continue;
                for (DiscoveredItem di : d) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)ss, (ItemStack)di.stack) && di.amount < di.consumed) continue;
                    di.amount += ss.getCount();
                    continue block1;
                }
                if (recipe instanceof PouringEmiRecipe) {
                    PouringEmiRecipe pouring = (PouringEmiRecipe)recipe;
                    optional = Optional.of(pouring);
                } else {
                    optional = EmiApi.getRecipeManager().getRecipes(BnCRecipeCategories.POURING).stream().filter(r -> {
                        if (!(r instanceof PouringEmiRecipe)) {
                            return false;
                        }
                        PouringEmiRecipe pouring = (PouringEmiRecipe)r;
                        return ((EmiStack)pouring.getFluidInput().getEmiStacks().getFirst()).isEqual(emiFluidStack) && ((EmiStack)((EmiIngredient)r.getInputs().getFirst()).getEmiStacks().getFirst()).isEqual(stack);
                    }).map(recipe1 -> (PouringEmiRecipe)recipe1).findFirst();
                }
                if (!(potentialPouring = optional).isPresent()) continue;
                int consumed = (int)(Math.min(((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().amount() * (long)context.getAmount(), ((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity()) / potentialPouring.get().getFluidInput().getAmount());
                if (recipe instanceof PouringEmiRecipe && consumed > context.getAmount()) {
                    consumed = context.getAmount();
                }
                if (consumed < 1) continue;
                d.add(new DiscoveredItem(stack, ss, ss.getCount(), consumed, (int)stack.getAmount()));
                discoveredQuickRef.add(stack);
            }
        }
        for (EmiStack inventoryStack : context.getInventory().inventory.values()) {
            int consumed;
            if (discoveredQuickRef.contains(inventoryStack)) continue;
            ItemStack itemStack = inventoryStack.getItemStack();
            AbstractedFluidTank tank = BrewinAndChewin.getHelper().getFluidContainerFromItem(itemStack);
            if (tank == null) continue;
            long target = tank.getAbstractedFluid().amount();
            if (!tank.getAbstractedFluid().isEmpty() || !tank.isFluidValid(0, fluidStack) || target <= 0L || (consumed = (int)(recipe instanceof PouringEmiRecipe ? ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().amount() : (((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() - ((KegMenu)context.getScreen().getMenu()).kegTank.getAbstractedFluid().amount()) / target)) < 1) continue;
            d.add(new DiscoveredItem(inventoryStack, itemStack, itemStack.getCount(), consumed * amount, (int)(((KegMenu)context.getScreen().getMenu()).kegTank.getFluidCapacity() / target)));
        }
        return BnCEMIRecipeFiller.handleFluidInternally(handler, recipe, context, amount, KegEmiRecipeHandler.InputType.EMPTY, desired, d);
    }

    private static boolean handleFluidInternally(KegEmiRecipeHandler handler, KegEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, KegEmiRecipeHandler.InputType inputType, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> desired, List<DiscoveredItem> d) {
        int n;
        ArrayList discovered = Lists.newArrayList();
        DiscoveredItem biggest = null;
        for (DiscoveredItem discoveredItem : d) {
            if (biggest == null) {
                biggest = discoveredItem;
                continue;
            }
            long ba = biggest.amount / biggest.consumed;
            long a = discoveredItem.amount / discoveredItem.consumed;
            if (ba >= a) continue;
            biggest = discoveredItem;
        }
        if (biggest == null) {
            return false;
        }
        discovered.add(biggest);
        ArrayList unique = Lists.newArrayList();
        block1: for (DiscoveredItem di : discovered) {
            if (di == null) continue;
            for (DiscoveredItem ui : unique) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)di.stack, (ItemStack)ui.stack)) continue;
                ui.consumed += di.consumed;
                continue block1;
            }
            unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max));
        }
        int n2 = Integer.MAX_VALUE;
        for (DiscoveredItem ui : unique) {
            if (ui.catalyst()) continue;
            int n = Math.min(n, ui.amount / ui.consumed);
            n = Math.min(n, ui.max);
        }
        int n3 = Math.min(n, amount + BnCEMIRecipeFiller.batchesAlreadyPresent(recipe, handler, (AbstractContainerScreen<KegMenu>)context.getScreen()));
        if (n3 == 0) {
            return false;
        }
        for (DiscoveredItem di : discovered) {
            if (di != null) {
                ItemStack is = di.stack.copy();
                int a = di.catalyst() ? di.consumed : di.consumed * n3;
                is.setCount(a);
                desired.computeIfAbsent(inputType, ip -> new ArrayList()).add(is);
                continue;
            }
            desired.computeIfAbsent(inputType, ip -> new ArrayList()).add(ItemStack.EMPTY);
        }
        return true;
    }

    private static int batchesAlreadyPresent(EmiRecipe recipe, KegEmiRecipeHandler handler, AbstractContainerScreen<KegMenu> screen) {
        if (recipe instanceof FermentingEmiRecipe) {
            return 0;
        }
        ArrayList stacks = Lists.newArrayList();
        Slot output = handler.getOutputSlot((KegMenu)screen.getMenu());
        if (!(output == null || output.getItem().isEmpty() || recipe.getOutputs().isEmpty() || ItemStack.matches((ItemStack)output.getItem(), (ItemStack)((EmiStack)recipe.getOutputs().getFirst()).getItemStack()))) {
            return 0;
        }
        for (Slot slot : handler.getCraftingSlots((KegMenu)screen.getMenu())) {
            if (slot != null) {
                stacks.add(slot.getItem());
                continue;
            }
            stacks.add(ItemStack.EMPTY);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < recipe.getInputs().size(); ++i) {
            EmiIngredient input = (EmiIngredient)recipe.getInputs().get(i);
            if (input.isEmpty()) {
                if (((ItemStack)stacks.get(i)).isEmpty()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((ItemStack)((ItemStack)stacks.get(i)));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public ItemStack stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, ItemStack stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.copy();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

