/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.BnCRecipeWorkstations;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;
import umpaz.brewinandchewin.integration.emi.recipe.CheeseEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.PouringEmiRecipe;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        PatchedDataComponentMap patched;
        DataComponentMap dataComponentMap;
        AbstractedFluidStack stack;
        registry.addCategory(BnCRecipeCategories.FERMENTING);
        registry.addCategory(BnCRecipeCategories.POURING);
        registry.addCategory(BnCRecipeCategories.AGING);
        registry.addWorkstation(BnCRecipeCategories.FERMENTING, (EmiIngredient)BnCRecipeWorkstations.KEG);
        registry.addRecipeHandler(BnCMenuTypes.KEG, (EmiRecipeHandler)new KegEmiRecipeHandler());
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.FERMENTING)) {
            if (((KegFermentingRecipe)recipe.value()).getResult().left().isPresent()) {
                DataComponentPatch dataComponentPatch;
                stack = (AbstractedFluidStack)((KegFermentingRecipe)recipe.value()).getResult().left().get();
                ResourceLocation resourceLocation = recipe.id();
                List<EmiIngredient> list = ((KegFermentingRecipe)recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
                EmiIngredient emiIngredient = this.getFluidItemIngredients(registry.getRecipeManager(), (RecipeHolder<KegFermentingRecipe>)recipe);
                EmiIngredient emiIngredient2 = this.getFluidIngredient((RecipeHolder<KegFermentingRecipe>)recipe);
                Fluid fluid = stack.fluid();
                dataComponentMap = stack.components();
                if (dataComponentMap instanceof PatchedDataComponentMap) {
                    patched = (PatchedDataComponentMap)dataComponentMap;
                    dataComponentPatch = patched.asPatch();
                } else {
                    dataComponentPatch = DataComponentPatch.EMPTY;
                }
                registry.addRecipe((EmiRecipe)new FermentingEmiRecipe(resourceLocation, list, emiIngredient, emiIngredient2, EmiStack.of((Fluid)fluid, (DataComponentPatch)dataComponentPatch, (long)stack.unit().convertToLoader(stack.amount())), ((KegFermentingRecipe)recipe.value()).getTemperature(), ((KegFermentingRecipe)recipe.value()).getFermentTime(), ((KegFermentingRecipe)recipe.value()).getExperience()));
                continue;
            }
            registry.addRecipe((EmiRecipe)new FermentingEmiRecipe(recipe.id(), ((KegFermentingRecipe)recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList(), this.getFluidItemIngredients(registry.getRecipeManager(), (RecipeHolder<KegFermentingRecipe>)recipe), this.getFluidIngredient((RecipeHolder<KegFermentingRecipe>)recipe), EmiStack.of((ItemStack)((KegFermentingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), ((KegFermentingRecipe)recipe.value()).getTemperature(), ((KegFermentingRecipe)recipe.value()).getFermentTime(), ((KegFermentingRecipe)recipe.value()).getExperience()));
        }
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().filter(pouringRecipe -> !((KegPouringRecipe)pouringRecipe.value()).hasSpecialFluid()).toList()) {
            DataComponentPatch dataComponentPatch;
            stack = ((KegPouringRecipe)recipe.value()).getRawFluid();
            ResourceLocation resourceLocation = recipe.id();
            Fluid fluid = stack.fluid();
            dataComponentMap = stack.components();
            if (dataComponentMap instanceof PatchedDataComponentMap) {
                patched = (PatchedDataComponentMap)dataComponentMap;
                dataComponentPatch = patched.asPatch();
            } else {
                dataComponentPatch = DataComponentPatch.EMPTY;
            }
            registry.addRecipe((EmiRecipe)new PouringEmiRecipe(resourceLocation, (EmiIngredient)EmiStack.of((Fluid)fluid, (DataComponentPatch)dataComponentPatch, (long)((KegPouringRecipe)recipe.value()).getUnit().convertToLoader(stack.amount())), EmiStack.of((ItemStack)((KegPouringRecipe)recipe.value()).getContainer()), EmiStack.of((ItemStack)((KegPouringRecipe)recipe.value()).getOutput())));
        }
        registry.addRecipe((EmiRecipe)new CheeseEmiRecipe(BrewinAndChewin.asResource("/cheese/flaxen"), EmiStack.of((ItemLike)BnCItems.UNRIPE_FLAXEN_CHEESE_WHEEL), EmiStack.of((ItemLike)BnCItems.FLAXEN_CHEESE_WHEEL)));
        registry.addRecipe((EmiRecipe)new CheeseEmiRecipe(BrewinAndChewin.asResource("/cheese/scarlet"), EmiStack.of((ItemLike)BnCItems.UNRIPE_SCARLET_CHEESE_WHEEL), EmiStack.of((ItemLike)BnCItems.SCARLET_CHEESE_WHEEL)));
    }

    private EmiIngredient getFluidIngredient(RecipeHolder<KegFermentingRecipe> recipe) {
        if (((KegFermentingRecipe)recipe.value()).getFluidIngredient().isEmpty()) {
            return null;
        }
        return EmiIngredient.of(((KegFermentingRecipe)recipe.value()).getFluidIngredient().orElseThrow().ingredient().displayStacks().stream().map(stack -> {
            DataComponentPatch dataComponentPatch;
            Fluid fluid = stack.fluid();
            DataComponentMap patt0$temp = stack.components();
            if (patt0$temp instanceof PatchedDataComponentMap) {
                PatchedDataComponentMap patched = (PatchedDataComponentMap)patt0$temp;
                dataComponentPatch = patched.asPatch();
            } else {
                dataComponentPatch = DataComponentPatch.EMPTY;
            }
            return EmiStack.of((Fluid)fluid, (DataComponentPatch)dataComponentPatch, (long)stack.unit().convertToLoader(stack.amount()));
        }).toList());
    }

    private EmiIngredient getFluidItemIngredients(RecipeManager recipes, RecipeHolder<KegFermentingRecipe> recipe) {
        if (((KegFermentingRecipe)recipe.value()).getFluidIngredient().isEmpty()) {
            return null;
        }
        int fluidAmount = (int)((KegFermentingRecipe)recipe.value()).getFluidIngredient().orElseThrow().getUnit().convert(((KegFermentingRecipe)recipe.value()).getFluidIngredient().get().amount(), FluidUnit.LITER);
        return EmiIngredient.of(recipes.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().filter(holder -> ((KegFermentingRecipe)recipe.value()).getFluidIngredient().get().ingredient().matches(((KegPouringRecipe)holder.value()).getRawFluid())).map(holder -> {
            ItemStack stack = ((KegPouringRecipe)holder.value()).getOutput();
            stack = stack.copyWithCount((int)((long)fluidAmount / ((KegPouringRecipe)holder.value()).getUnit().convert(((KegPouringRecipe)holder.value()).getRawFluid().amount(), FluidUnit.LITER)));
            return EmiStack.of((ItemStack)stack);
        }).toList());
    }
}

