/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.utility;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.platform.BnCPlatform;

public enum FluidUnit implements StringRepresentable
{
    LITER("liters", l -> l + " L", l -> l + " liters", 1L),
    MILLIBUCKET("millibuckets", l -> l + " mB", l -> l + " millibuckets", 1L),
    DROPLET("droplets", l -> l + " d", l -> l + " droplets", 81L);

    private final String name;
    private final Function<String, String> shortFormFormatFunc;
    private final Function<String, String> longFormFormatFunc;
    private final long oneL;
    public static final Codec<FluidUnit> CODEC;
    public static final IntFunction<FluidUnit> BY_ID;
    public static final StreamCodec<ByteBuf, FluidUnit> STREAM_CODEC;

    private FluidUnit(String name, Function<String, String> shortFormFormatFunc, Function<String, String> longFormFormatFunc, long oneL) {
        this.name = name;
        this.shortFormFormatFunc = shortFormFormatFunc;
        this.longFormFormatFunc = longFormFormatFunc;
        this.oneL = oneL;
    }

    public long convert(long value, FluidUnit unit) {
        return FluidUnit.convert(value, this, unit);
    }

    public long convertToLoader(long value) {
        return FluidUnit.convertToLoader(value, this);
    }

    public static FluidUnit getOpposite(FluidUnit unit) {
        if (unit == DROPLET) {
            return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? MILLIBUCKET : LITER;
        }
        return DROPLET;
    }

    public static FluidUnit getLoaderUnit() {
        return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? MILLIBUCKET : DROPLET;
    }

    public static long convertToLoader(long value, FluidUnit unit) {
        return FluidUnit.convert(value, unit, FluidUnit.getLoaderUnit());
    }

    public static long convert(long value, FluidUnit originalUnit, FluidUnit newUnit) {
        if (originalUnit.oneL == newUnit.oneL) {
            return value;
        }
        return value / originalUnit.oneL * newUnit.oneL;
    }

    public String shortFormat(String value) {
        return this.shortFormFormatFunc.apply(value);
    }

    public String longFormat(String value) {
        return this.longFormFormatFunc.apply(value);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(FluidUnit::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FluidUnit.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

