/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.utility;

import com.mojang.serialization.Codec;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class AbstractedFluidStack {
    public static final Codec<AbstractedFluidStack> CODEC = BrewinAndChewin.getHelper().getFluidStackWrapperCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, AbstractedFluidStack> STREAM_CODEC = BrewinAndChewin.getHelper().getFluidStackWrapperStreamCodec();
    public static final AbstractedFluidStack EMPTY = new AbstractedFluidStack(Fluids.EMPTY, 0L, (DataComponentMap)new PatchedDataComponentMap(DataComponentMap.EMPTY), FluidUnit.getLoaderUnit(), null);
    private final Fluid fluid;
    private final long amount;
    private final DataComponentPatch components;
    private final FluidUnit unit;
    private Object loaderSpecific;

    public AbstractedFluidStack(Fluid fluid, long amount, DataComponentMap components, FluidUnit unit, Object loaderSpecific) {
        DataComponentPatch dataComponentPatch;
        this.fluid = fluid;
        this.amount = amount;
        if (components instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap patched = (PatchedDataComponentMap)components;
            dataComponentPatch = patched.asPatch();
        } else {
            dataComponentPatch = DataComponentPatch.EMPTY;
        }
        this.components = dataComponentPatch;
        this.unit = unit;
        this.loaderSpecific = loaderSpecific;
    }

    public AbstractedFluidStack(Fluid fluid, long amount, DataComponentMap components) {
        this(fluid, amount, components, FluidUnit.getLoaderUnit(), null);
    }

    public AbstractedFluidStack(Fluid fluid, long amount, DataComponentMap components, FluidUnit unit) {
        this(fluid, amount, components, unit, null);
    }

    public AbstractedFluidStack(Fluid fluid, long amount) {
        this(fluid, amount, (DataComponentMap)new PatchedDataComponentMap(DataComponentMap.EMPTY), FluidUnit.getLoaderUnit(), null);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.fluid == Fluids.EMPTY || this.amount <= 0L;
    }

    public boolean matches(AbstractedFluidStack other) {
        return this.fluid == other.fluid && this.components.equals((Object)other.components);
    }

    public Fluid fluid() {
        return this.isEmpty() ? Fluids.EMPTY : this.fluid;
    }

    public long amount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public DataComponentMap components() {
        return PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)this.components);
    }

    public DataComponentPatch componentPatch() {
        return this.components;
    }

    public FluidUnit unit() {
        return this.unit;
    }

    public Object loaderSpecific() {
        if (this.loaderSpecific == null) {
            this.loaderSpecific = BrewinAndChewin.getHelper().createLoaderFluidStack(this);
        }
        return BrewinAndChewin.getHelper().copyLoaderFluidStack(this.loaderSpecific);
    }
}

