/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.serverbound;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;

public record EMIFillFermentingRecipeServerboundPacket(int syncId, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BrewinAndChewin.asResource("emi_fill_fermenting_recipe");
    public static final CustomPacketPayload.Type<EMIFillFermentingRecipeServerboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, EMIFillFermentingRecipeServerboundPacket> STREAM_CODEC = StreamCodec.of(EMIFillFermentingRecipeServerboundPacket::encode, EMIFillFermentingRecipeServerboundPacket::new);

    public EMIFillFermentingRecipeServerboundPacket(KegMenu menu, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks) {
        this(menu.containerId, stacks);
    }

    public EMIFillFermentingRecipeServerboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), (Map<KegEmiRecipeHandler.InputType, List<ItemStack>>)((Map)ByteBufCodecs.map(HashMap::new, KegEmiRecipeHandler.InputType.STREAM_CODEC, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list())).decode((Object)buf)));
    }

    public static void encode(RegistryFriendlyByteBuf buf, EMIFillFermentingRecipeServerboundPacket packet) {
        buf.writeInt(packet.syncId);
        ByteBufCodecs.map(HashMap::new, KegEmiRecipeHandler.InputType.STREAM_CODEC, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list())).encode((Object)buf, new HashMap<KegEmiRecipeHandler.InputType, List<ItemStack>>(packet.stacks));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(ServerPlayer sender) {
        sender.server.execute(() -> {
            block21: {
                if (!BrewinAndChewin.getHelper().isModLoaded("emi")) {
                    return;
                }
                AbstractContainerMenu menu = sender.containerMenu;
                if (menu.containerId != this.syncId || !(menu instanceof KegMenu)) {
                    BrewinAndChewin.LOG.error("Attempted to transfer fermenting recipe to an incorrect menu");
                    return;
                }
                KegMenu kegMenu = (KegMenu)menu;
                ArrayList rubble = Lists.newArrayList();
                try {
                    List crafting;
                    if (this.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.EMPTY)) {
                        crafting = List.of(menu.getSlot(4));
                        for (Slot s : crafting) {
                            if (s == null || !s.mayPickup((Player)sender) || s.getItem().isEmpty()) continue;
                            ItemStack taken = s.getItem();
                            rubble.add(taken.copy());
                            s.setByPlayer(ItemStack.EMPTY);
                            s.onTake((Player)sender, taken);
                        }
                        for (ItemStack stack : this.stacks.get((Object)KegEmiRecipeHandler.InputType.EMPTY)) {
                            if (stack.isEmpty()) continue;
                            int gotten = EMIFillFermentingRecipeServerboundPacket.grabMatching(kegMenu, (Player)sender, crafting, rubble, stack);
                            if (gotten != stack.getCount()) {
                                if (gotten <= 0) break;
                                stack.setCount(gotten);
                                sender.getInventory().placeItemBackInInventory(stack);
                                break;
                            }
                            for (ItemStack items : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                                sender.getInventory().placeItemBackInInventory(items);
                            }
                        }
                    }
                    if (this.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.FILL)) {
                        crafting = List.of(menu.getSlot(4));
                        for (Slot s : crafting) {
                            if (s == null || !s.mayPickup((Player)sender) || s.getItem().isEmpty()) continue;
                            ItemStack taken = s.getItem();
                            rubble.add(taken.copy());
                            s.setByPlayer(ItemStack.EMPTY);
                            s.onTake((Player)sender, taken);
                        }
                        for (ItemStack stack : this.stacks.get((Object)KegEmiRecipeHandler.InputType.FILL)) {
                            if (stack.isEmpty()) continue;
                            int gotten = EMIFillFermentingRecipeServerboundPacket.grabMatching(kegMenu, (Player)sender, crafting, rubble, stack);
                            if (gotten != stack.getCount()) {
                                if (gotten <= 0) break;
                                stack.setCount(gotten);
                                sender.getInventory().placeItemBackInInventory(stack);
                                break;
                            }
                            for (ItemStack items : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                                sender.getInventory().placeItemBackInInventory(items);
                            }
                        }
                    }
                    if (!this.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.ITEM)) break block21;
                    crafting = menu.slots.subList(0, 3);
                    for (Slot s : crafting) {
                        if (s == null || !s.mayPickup((Player)sender) || s.getItem().isEmpty()) continue;
                        ItemStack taken = s.getItem();
                        rubble.add(taken.copy());
                        s.setByPlayer(ItemStack.EMPTY);
                        s.onTake((Player)sender, taken);
                    }
                    for (int i = 0; i < this.stacks.get((Object)KegEmiRecipeHandler.InputType.ITEM).size(); ++i) {
                        ItemStack stack;
                        stack = this.stacks.get((Object)KegEmiRecipeHandler.InputType.ITEM).get(i);
                        if (stack.isEmpty()) continue;
                        int gotten = EMIFillFermentingRecipeServerboundPacket.grabMatching(kegMenu, (Player)sender, crafting, rubble, stack);
                        if (gotten != stack.getCount()) {
                            if (gotten > 0) {
                                stack.setCount(gotten);
                                sender.getInventory().placeItemBackInInventory(stack);
                            }
                            break;
                        }
                        Slot s = menu.getSlot(i);
                        if (s.mayPlace(stack) && stack.getCount() <= s.getMaxStackSize()) {
                            s.setByPlayer(stack);
                            continue;
                        }
                        sender.getInventory().placeItemBackInInventory(stack);
                    }
                }
                finally {
                    for (ItemStack stack : rubble) {
                        sender.getInventory().placeItemBackInInventory(stack);
                    }
                }
            }
        });
    }

    private static int grabMatching(KegMenu menu, Player player, List<Slot> crafting, List<ItemStack> rubble, ItemStack stack) {
        int amount = stack.getCount();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r)) continue;
            int wanted = amount - grabbed;
            if (r.getCount() <= wanted) {
                grabbed += r.getCount();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.setCount(r.getCount() - wanted);
        }
        for (Slot s : menu.slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.mayPickup(player) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(st = s.getItem()))) continue;
            int wanted = amount - grabbed;
            ItemStack taken = st.copy();
            if (st.getCount() <= wanted) {
                grabbed += st.getCount();
                s.setByPlayer(ItemStack.EMPTY);
            } else {
                grabbed = amount;
                st.setCount(st.getCount() - wanted);
            }
            s.onTake(player, taken);
        }
        return grabbed;
    }
}

