/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;

public class BnCCopyMealFunction
extends LootItemConditionalFunction {
    public static final MapCodec<BnCCopyMealFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> BnCCopyMealFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, BnCCopyMealFunction::new));
    public static final ResourceLocation ID = BrewinAndChewin.asResource("copy_meal");
    public static final LootItemFunctionType<BnCCopyMealFunction> TYPE = new LootItemFunctionType(CODEC);

    private BnCCopyMealFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return BnCCopyMealFunction.simpleBuilder(BnCCopyMealFunction::new);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity tile = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof KegBlockEntity) {
            KegBlockEntity kegTile = (KegBlockEntity)tile;
            CustomData data = kegTile.writeMeal(((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag(), (HolderLookup.Provider)context.getLevel().registryAccess());
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)data);
        }
        return stack;
    }

    public LootItemFunctionType<BnCCopyMealFunction> getType() {
        return TYPE;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        Builder() {
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new BnCCopyMealFunction(this.getConditions());
        }
    }
}

