/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegPouringRecipe
implements Recipe<KegRecipeWrapper> {
    private final AbstractedFluidStack fluid;
    private final Optional<ItemStack> container;
    private final ItemStack output;
    private final Optional<FluidUnit> unit;
    private final boolean strict;
    private final boolean filling;

    public KegPouringRecipe(AbstractedFluidStack fluid, Optional<ItemStack> container, ItemStack output, Optional<FluidUnit> unit, boolean strict, boolean filling) {
        if (container.isEmpty() && BrewinAndChewin.getHelper().getCraftingRemainingItem(output).isEmpty()) {
            throw new UnsupportedOperationException("'container' field must be specified as the output item stack doesn't have a crafting remainder item.");
        }
        this.fluid = fluid;
        this.container = container;
        this.output = output;
        this.unit = unit;
        this.strict = strict;
        this.filling = filling;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredient = NonNullList.create();
        ingredient.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{this.getContainer()}));
        return ingredient;
    }

    public boolean matches(KegRecipeWrapper inv, Level level) {
        return Ingredient.of((ItemStack[])new ItemStack[]{this.getContainer()}).test(inv.getItem(4));
    }

    public ItemStack assemble(KegRecipeWrapper recipeWrapper, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getContainer() {
        return this.container.orElse(BrewinAndChewin.getHelper().getCraftingRemainingItem(this.output));
    }

    public ItemStack getContainer(ItemStack stack) {
        return this.container.orElse(BrewinAndChewin.getHelper().getCraftingRemainingItem(stack));
    }

    public Optional<FluidUnit> getRawUnit() {
        return this.unit;
    }

    public FluidUnit getUnit() {
        return this.unit.orElse(FluidUnit.getLoaderUnit());
    }

    public long getLoaderAmount() {
        return this.getUnit().convertToLoader(this.fluid.amount());
    }

    public Optional<ItemStack> getRawContainer() {
        return this.container;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public AbstractedFluidStack getFluid(ItemStack container) {
        return this.fluid;
    }

    public AbstractedFluidStack getRawFluid() {
        return this.fluid;
    }

    public boolean hasSpecialFluid() {
        return false;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean canFill() {
        return this.filling;
    }

    public RecipeSerializer<?> getSerializer() {
        return BnCRecipeSerializers.KEG_POURING;
    }

    public RecipeType<?> getType() {
        return BnCRecipeTypes.KEG_POURING;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BnCItems.KEG);
    }

    public boolean isSpecial() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.container, this.output, this.strict, this.filling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegPouringRecipe that = (KegPouringRecipe)o;
        if (!this.output.equals(that.output)) {
            return false;
        }
        if (!this.fluid.equals(that.fluid)) {
            return false;
        }
        if (!this.container.equals(that.container)) {
            return false;
        }
        if (this.strict != that.strict) {
            return false;
        }
        return this.filling == that.filling;
    }

    public static class Serializer
    implements RecipeSerializer<KegPouringRecipe> {
        public static final MapCodec<KegPouringRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)AbstractedFluidStack.CODEC.fieldOf("fluid").forGetter(KegPouringRecipe::getRawFluid), (App)ItemStack.CODEC.optionalFieldOf("container").forGetter(KegPouringRecipe::getRawContainer), (App)ItemStack.CODEC.fieldOf("output").forGetter(KegPouringRecipe::getOutput), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(KegPouringRecipe::getRawUnit), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(KegPouringRecipe::isStrict), (App)Codec.BOOL.optionalFieldOf("can_fill", (Object)true).forGetter(KegPouringRecipe::canFill)).apply((Applicative)inst, KegPouringRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KegPouringRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<KegPouringRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, KegPouringRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, KegPouringRecipe recipe) {
            AbstractedFluidStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getRawFluid());
            ByteBufCodecs.optional((StreamCodec)ItemStack.STREAM_CODEC).encode((Object)buf, recipe.getRawContainer());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
            ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).encode((Object)buf, recipe.getRawUnit());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)recipe.isStrict());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)recipe.canFill());
        }

        public static KegPouringRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            AbstractedFluidStack fluid = (AbstractedFluidStack)AbstractedFluidStack.STREAM_CODEC.decode((Object)buf);
            Optional container = (Optional)ByteBufCodecs.optional((StreamCodec)ItemStack.STREAM_CODEC).decode((Object)buf);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            Optional unit = (Optional)ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).decode((Object)buf);
            boolean strict = buf.readBoolean();
            boolean canFill = buf.readBoolean();
            return new KegPouringRecipe(fluid, container, output, unit, strict, canFill);
        }
    }
}

