/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import umpaz.brewinandchewin.client.recipebook.FermentingBookCategory;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.FluidIngredientWithAmount;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCRecipeUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegFermentingRecipe
implements Recipe<KegRecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final NonNullList<Ingredient> inputItems;
    private final Optional<FluidIngredientWithAmount> fluidIngredient;
    private final Optional<FluidUnit> unit;
    private final FermentingBookCategory tab;
    private final Either<AbstractedFluidStack, ItemStack> result;
    private final float experience;
    private final int fermentTime;
    private final int temperature;

    public KegFermentingRecipe(NonNullList<Ingredient> inputItems, FermentingBookCategory tab, Optional<FluidIngredientWithAmount> fluidIngredient, Optional<FluidUnit> unit, Either<AbstractedFluidStack, ItemStack> result, float experience, int fermentTime, int temperature) {
        this.inputItems = inputItems;
        this.tab = tab;
        this.fluidIngredient = fluidIngredient;
        this.unit = unit;
        this.result = unit.isPresent() && result.left().isPresent() ? Either.left((Object)new AbstractedFluidStack(((AbstractedFluidStack)result.left().get()).fluid(), ((AbstractedFluidStack)result.left().get()).amount(), ((AbstractedFluidStack)result.left().get()).components(), unit.get(), ((AbstractedFluidStack)result.left().get()).loaderSpecific())) : result;
        this.experience = experience;
        this.fermentTime = fermentTime;
        this.temperature = temperature;
    }

    public FermentingBookCategory getRecipeBookCategory() {
        return this.tab;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public Optional<FluidIngredientWithAmount> getFluidIngredient() {
        return this.fluidIngredient;
    }

    public Optional<FluidUnit> getRawUnit() {
        return this.unit;
    }

    public FluidUnit getUnit() {
        return this.unit.orElse(FluidUnit.getLoaderUnit());
    }

    public Either<AbstractedFluidStack, ItemStack> getResult() {
        return this.result;
    }

    public ItemStack assemble(KegRecipeWrapper inv, HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getFermentTime() {
        return this.fermentTime;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(KegRecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (!itemstack.isEmpty()) {
                inputs.add(itemstack);
                continue;
            }
            inputs.add(ItemStack.EMPTY);
        }
        CraftingInput input = CraftingInput.of((int)2, (int)2, inputs);
        return input.size() == 1 && this.inputItems.size() == 1 ? ((Ingredient)this.inputItems.getFirst()).test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null) && (this.fluidIngredient.isEmpty() && inv.getFluid().isEmpty() || this.fluidIngredient.isPresent() && !inv.getFluid().isEmpty() && this.fluidIngredient.get().ingredient().matches(inv.getFluid()) && inv.getFluid().amount() % this.fluidIngredient.get().amount() == 0L);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        if (this.result.right().isPresent()) {
            return ((ItemStack)this.result.right().get()).copy();
        }
        if (this.result.left().isPresent()) {
            return BnCRecipeUtils.getPouredItemFromFluid(new AbstractedFluidStack(((AbstractedFluidStack)this.result.left().get()).fluid(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), ((AbstractedFluidStack)this.result.left().get()).components(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacityUnit(), null));
        }
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return BnCRecipeSerializers.FERMENTING;
    }

    public RecipeType<?> getType() {
        return BnCRecipeTypes.FERMENTING;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BnCItems.KEG);
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().allMatch(Ingredient::isEmpty);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegFermentingRecipe that = (KegFermentingRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getFermentTime() != that.getFermentTime()) {
            return false;
        }
        if (this.getTemperature() != that.getTemperature()) {
            return false;
        }
        if (this.getResult() != that.getResult()) {
            return false;
        }
        if (this.getFluidIngredient() != that.getFluidIngredient()) {
            return false;
        }
        return this.inputItems.equals(that.inputItems);
    }

    public int hashCode() {
        return Objects.hash(this.inputItems, this.fluidIngredient, this.result, Float.valueOf(this.experience), this.fermentTime, this.temperature);
    }

    public static class Serializer
    implements RecipeSerializer<KegFermentingRecipe> {
        public static final MapCodec<KegFermentingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.listOf(1, 4).xmap(ingredients -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new))), Function.identity()).fieldOf("ingredients").forGetter(KegFermentingRecipe::getIngredients), (App)FermentingBookCategory.CODEC.optionalFieldOf("category", (Object)FermentingBookCategory.DRINKS).forGetter(KegFermentingRecipe::getRecipeBookCategory), (App)FluidIngredientWithAmount.CODEC.optionalFieldOf("base_fluid").forGetter(KegFermentingRecipe::getFluidIngredient), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(KegFermentingRecipe::getRawUnit), (App)Codec.either(AbstractedFluidStack.CODEC, (Codec)ItemStack.CODEC).fieldOf("result").forGetter(KegFermentingRecipe::getResult), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(KegFermentingRecipe::getExperience), (App)Codec.INT.optionalFieldOf("fermenting_time", (Object)9600).forGetter(KegFermentingRecipe::getFermentTime), (App)Codec.INT.optionalFieldOf("temperature", (Object)3).forGetter(KegFermentingRecipe::getTemperature)).apply((Applicative)inst, KegFermentingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KegFermentingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<KegFermentingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, KegFermentingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, KegFermentingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list((int)4)).encode((Object)buf, recipe.getIngredients());
            FermentingBookCategory.STREAM_CODEC.encode((Object)buf, (Object)recipe.getRecipeBookCategory());
            ByteBufCodecs.optional(FluidIngredientWithAmount.STREAM_CODEC).encode((Object)buf, recipe.getFluidIngredient());
            ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).encode((Object)buf, recipe.getRawUnit());
            ByteBufCodecs.either(AbstractedFluidStack.STREAM_CODEC, (StreamCodec)ItemStack.STREAM_CODEC).encode((Object)buf, recipe.getResult());
            buf.writeFloat(recipe.getExperience());
            buf.writeInt(recipe.getFermentTime());
            buf.writeInt(recipe.getTemperature());
        }

        public static KegFermentingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])((List)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list((int)4)).decode((Object)buf)).toArray(Ingredient[]::new)));
            FermentingBookCategory category = (FermentingBookCategory)((Object)FermentingBookCategory.STREAM_CODEC.decode((Object)buf));
            Optional fluidIngredient = (Optional)ByteBufCodecs.optional(FluidIngredientWithAmount.STREAM_CODEC).decode((Object)buf);
            Optional fluidUnit = (Optional)ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).decode((Object)buf);
            Either result = (Either)ByteBufCodecs.either(AbstractedFluidStack.STREAM_CODEC, (StreamCodec)ItemStack.STREAM_CODEC).decode((Object)buf);
            float experience = buf.readFloat();
            int fermentingTime = buf.readInt();
            int temperature = buf.readInt();
            return new KegFermentingRecipe((NonNullList<Ingredient>)ingredients, category, fluidIngredient, fluidUnit, (Either<AbstractedFluidStack, ItemStack>)result, experience, fermentingTime, temperature);
        }
    }
}

