/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import umpaz.brewinandchewin.common.registry.BnCParticleTypes;

public class IceCrateBlock
extends Block {
    private static final VoxelShape FOG_AREA = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);

    public IceCrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(2) == 0 && this.isSpaceAbove(level, pos)) {
            Supplier<Vec3> supplier = () -> new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)random, (double)-0.025f, (double)-0.01f), Mth.nextDouble((RandomSource)random, (double)-0.005f, (double)0.005f));
            for (Direction direction : Direction.values()) {
                ParticleUtils.spawnParticlesOnBlockFace((Level)level, (BlockPos)pos, (ParticleOptions)BnCParticleTypes.FOG, (IntProvider)UniformInt.of((int)1, (int)1), (Direction)direction, supplier, (double)(direction == Direction.UP ? 0.25 : 0.55));
            }
        }
    }

    public boolean isSpaceAbove(Level level, BlockPos pos) {
        if (level != null) {
            BlockState above = level.getBlockState(pos.above());
            return !Shapes.joinIsNotEmpty((VoxelShape)FOG_AREA, (VoxelShape)above.getShape((BlockGetter)level, pos.above()), (BooleanOp)BooleanOp.AND);
        }
        return true;
    }
}

