/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import java.util.ArrayList;
import java.util.List;

public interface TagReference {
    public static TagReference createArrayValue(int index) {
        if (index < 0) {
            throw new IllegalStateException("Cannot create an array value with an index less than 0.");
        }
        return new ArrayValue(index);
    }

    public static TagReference createObject(String key) {
        return new Object(key);
    }

    public static List<TagReference> createFromString(String string) {
        String[] strings;
        ArrayList<TagReference> references = new ArrayList<TagReference>();
        for (String key : strings = string.split("\\.")) {
            if (key.matches("/\\[[0-9]+]/")) {
                references.add(TagReference.createArrayValue(Integer.getInteger(key.substring(1, key.length() - 1))));
                continue;
            }
            references.add(TagReference.createObject(key));
        }
        return references;
    }

    default public boolean isArrayValue() {
        return this instanceof ArrayValue;
    }

    default public boolean isObject() {
        return this instanceof Object;
    }

    default public int index() {
        return -1;
    }

    default public String key() {
        return "";
    }

    public record ArrayValue(int index) implements TagReference
    {
    }

    public record Object(String key) implements TagReference
    {
    }
}

