/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.renderer.texture.BnCTextureModifiers;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.common.block.CoasterBlock;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;

public class CoasterBlockEntityRenderer
implements BlockEntityRenderer<CoasterBlockEntity> {
    private static final Map<ResourceLocation, List<ModelEntry>> ITEM_TO_MODELS = new HashMap<ResourceLocation, List<ModelEntry>>();
    private static final Set<ResourceLocation> ERRONEOUS_ENTRIES = new HashSet<ResourceLocation>();

    public static void resetCache() {
        ITEM_TO_MODELS.clear();
        ERRONEOUS_ENTRIES.clear();
    }

    public static List<ModelEntry> getModelEntries(ResourceLocation itemId) {
        return ITEM_TO_MODELS.get(itemId);
    }

    public static void addToModelMap(ResourceLocation itemId, List<ModelEntry> models) {
        ITEM_TO_MODELS.put(itemId, models);
    }

    public CoasterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    private void poseUtil(PoseStack poseStack, int fullCount, int curCount, RandomSource seededRandom, boolean invisible) {
        Vector2f translateVec = switch (fullCount) {
            case 2 -> {
                if (curCount == 0) {
                    yield new Vector2f(-0.2f, -0.15f);
                }
                yield new Vector2f(0.2f, 0.15f);
            }
            case 3 -> {
                if (curCount == 0) {
                    yield new Vector2f(0.05f, 0.25f);
                }
                if (curCount == 1) {
                    yield new Vector2f(-0.25f, -0.15f);
                }
                yield new Vector2f(0.25f, -0.25f);
            }
            case 4 -> {
                if (curCount == 0) {
                    yield new Vector2f(0.2f, 0.25f);
                }
                if (curCount == 1) {
                    yield new Vector2f(-0.25f, 0.2f);
                }
                if (curCount == 2) {
                    yield new Vector2f(0.25f, -0.2f);
                }
                yield new Vector2f(-0.2f, -0.25f);
            }
            default -> new Vector2f();
        };
        float rotation = switch (fullCount) {
            case 2 -> {
                if (curCount == 0) {
                    yield 190.0f;
                }
                yield 10.0f;
            }
            case 3 -> {
                if (curCount == 0) {
                    yield -20.0f;
                }
                if (curCount == 1) {
                    yield 220.0f;
                }
                yield 100.0f;
            }
            case 4 -> {
                if (curCount == 0) {
                    yield -5.0f;
                }
                if (curCount == 1) {
                    yield 265.0f;
                }
                if (curCount == 2) {
                    yield 85.0f;
                }
                yield 175.0f;
            }
            default -> 0.0f;
        };
        poseStack.rotateAround(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, rotation + seededRandom.nextFloat() * 20.0f - 10.0f), 0.5f + translateVec.x(), 0.0f, 0.5f + translateVec.y());
        poseStack.translate((double)translateVec.x(), invisible ? 0.0 : 0.0625, (double)translateVec.y());
    }

    public void render(CoasterBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int count = (int)entity.getItems().stream().filter(i -> !i.isEmpty()).count();
        poseStack.rotateAround(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -22.5f * (float)((Integer)entity.getBlockState().getValue((Property)CoasterBlock.ROTATION)).intValue()), 0.5f, 0.0f, 0.5f);
        LegacyRandomSource random = new LegacyRandomSource(entity.getBlockPos().asLong());
        if (!((Boolean)entity.getBlockState().getValue((Property)CoasterBlock.INVISIBLE)).booleanValue() || count == 0) {
            poseStack.pushPose();
            ResourceLocation modelId = (Integer)entity.getBlockState().getValue((Property)CoasterBlock.SIZE) > 1 ? BrewinAndChewin.asResource("block/coaster_tray") : BrewinAndChewin.asResource("block/coaster");
            BrewinAndChewinClient.getHelper().tesselateCoasterModel((BlockAndTintGetter)entity.getLevel(), modelId, entity.getBlockState(), entity.getBlockPos(), poseStack, buffer, (RandomSource)random, entity.getBlockPos().asLong(), combinedOverlay, -1, RenderType.cutout());
            poseStack.popPose();
        }
        int tintIndex = -1;
        for (int i2 = 0; i2 < count; ++i2) {
            ItemStack stack = (ItemStack)entity.getItems().get(i2);
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            List<ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
            poseStack.pushPose();
            this.poseUtil(poseStack, count, i2, (RandomSource)random, (Boolean)entity.getBlockState().getValue((Property)CoasterBlock.INVISIBLE));
            if (modelEntries != null) {
                for (ModelEntry modelEntry : modelEntries) {
                    ResourceLocation modelPath = modelEntry.model.withPath(path -> "brewinandchewin/coaster/" + path);
                    if (!CoasterBlockEntityRenderer.checkModel(modelPath)) continue;
                    int color = -1;
                    RenderType renderType = RenderType.cutout();
                    for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                        for (TextureModifier textureModifier : modelEntry.modifiers()) {
                            color = textureModifier.color((BlockAndTintGetter)entity.getLevel(), entity.getBlockState(), entity.getBlockPos(), stack, color);
                            renderType = textureModifier.renderType((BlockAndTintGetter)entity.getLevel(), entity.getBlockState(), entity.getBlockPos(), stack, renderType);
                        }
                    }
                    int finalTintIndex = -1;
                    if (color != -1) {
                        finalTintIndex = ++tintIndex;
                    }
                    BrewinAndChewinClient.getHelper().tesselateCoasterModel((BlockAndTintGetter)entity.getLevel(), modelPath, entity.getBlockState(), entity.getBlockPos(), poseStack, buffer, (RandomSource)random, entity.getBlockPos().asLong(), combinedOverlay, finalTintIndex, renderType);
                }
            } else {
                poseStack.translate(0.51, 0.05, 0.5);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, entity.getLevel(), (int)entity.getBlockPos().asLong());
            }
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(CoasterBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }

    public static boolean checkModel(ResourceLocation path) {
        BakedModel model = BrewinAndChewinClient.getHelper().getModel(path);
        if (!ERRONEOUS_ENTRIES.contains(path) && model == Minecraft.getInstance().getModelManager().getMissingModel()) {
            BrewinAndChewin.LOG.error("Failed to get model '{}'", (Object)path.withPath(p -> p.substring(24)));
            ERRONEOUS_ENTRIES.add(path);
            return false;
        }
        return true;
    }

    public record ModelEntry(ResourceLocation model, List<? extends TextureModifier> modifiers) {
        private static final Codec<ModelEntry> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(ModelEntry::model), (App)BnCTextureModifiers.CODEC.listOf().optionalFieldOf("texture_modifiers", List.of()).forGetter(modelEntry -> modelEntry.modifiers())).apply((Applicative)inst, ModelEntry::new));
        public static final Codec<List<ModelEntry>> LIST_CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)DIRECT_CODEC.listOf()).xmap(either -> (List)either.map(resourceLocation -> List.of(new ModelEntry((ResourceLocation)resourceLocation, List.of())), Function.identity()), modelEntry -> {
            if (modelEntry.size() == 1 && ((ModelEntry)modelEntry.get(0)).modifiers().isEmpty()) {
                return Either.left((Object)((ModelEntry)modelEntry.get(0)).model());
            }
            return Either.right((Object)modelEntry);
        });
    }
}

