/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.gui.KegRecipeBookComponent;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.client.utility.BnCRectangle;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegScreen
extends AbstractContainerScreen<KegMenu>
implements RecipeUpdateListener {
    public static final ResourceLocation BACKGROUND_TEXTURE = BrewinAndChewin.asResource("textures/gui/keg.png");
    private static final BnCRectangle PROGRESS_ARROW = new BnCRectangle(80, 25, 0, 18);
    public static final BnCRectangle COLD_BAR = new BnCRectangle(35, 55, 8, 4);
    public static final BnCRectangle CHILLY_BAR = new BnCRectangle(43, 55, 9, 4);
    public static final BnCRectangle WARM_BAR = new BnCRectangle(60, 55, 9, 4);
    public static final BnCRectangle HOT_BAR = new BnCRectangle(69, 55, 8, 4);
    private static final BnCRectangle LEFT_BUBBLE = new BnCRectangle(109, 44, 9, 24);
    private static final BnCRectangle RIGHT_BUBBLE = new BnCRectangle(147, 44, 9, 24);
    private final KegRecipeBookComponent recipeBookComponent;
    private boolean widthTooNarrow;
    private static final Map<Fluid, Component> FLUID_CONTAINER_COMPONENTS = new HashMap<Fluid, Component>();

    public KegScreen(KegMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.recipeBookComponent = new KegRecipeBookComponent(Minecraft.getInstance().level.getRecipeManager());
        this.leftPos = 0;
        this.topPos = 0;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.titleLabelX = 28;
    }

    public void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.titleLabelX = 38;
        this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
        if (((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).recipeBook().enabled()) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
                this.recipeBookComponent.toggleVisibility();
                this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
                button.setPosition(this.leftPos + 5, this.height / 2 - 49);
            }));
        } else {
            this.recipeBookComponent.hide();
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
        }
        this.addWidget((GuiEventListener)this.recipeBookComponent);
        this.setInitialFocus((GuiEventListener)this.recipeBookComponent);
    }

    protected void containerTick() {
        super.containerTick();
        this.recipeBookComponent.tick();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.renderBackground(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(gui, mouseX, mouseY, partialTicks);
        } else {
            super.render(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.render(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.renderGhostRecipe(gui, this.leftPos, this.topPos, false, partialTicks);
        }
        gui.blit(BACKGROUND_TEXTURE, this.leftPos + 119, this.topPos + 15, 176, 22, 27, 33);
        this.renderTankTooltip(gui, mouseX, mouseY);
        this.renderTemperatureTooltip(gui, mouseX, mouseY);
        this.renderTooltip(gui, mouseX, mouseY);
        this.recipeBookComponent.renderTooltip(gui, this.leftPos, this.topPos, mouseX, mouseY);
    }

    public static void clearFluidContainerComponents() {
        FLUID_CONTAINER_COMPONENTS.clear();
    }

    private void renderTankTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        KegFermentingRecipe fermentingRecipe;
        Recipe recipe;
        if (this.isHovering(120, 19, 24, 28, mouseX, mouseY) && !((KegMenu)this.menu).kegTank.isEmpty() && (this.recipeBookComponent.getGhostRecipe() == null || !((recipe = this.recipeBookComponent.getGhostRecipe().value()) instanceof KegFermentingRecipe) || (fermentingRecipe = (KegFermentingRecipe)recipe).getResult().left().isPresent() && ((AbstractedFluidStack)fermentingRecipe.getResult().left().get()).matches(((KegMenu)this.menu).kegTank.getAbstractedFluid()))) {
            MutableComponent containerComponent = BnCTextUtils.getTranslation("container.keg.served_in", FLUID_CONTAINER_COMPONENTS.computeIfAbsent(((KegMenu)this.menu).kegTank.getAbstractedFluid().fluid(), fluid -> {
                MutableComponent component = MutableComponent.create((ComponentContents)PlainTextContents.EMPTY).withStyle(ChatFormatting.GRAY);
                int amountAdded = 0;
                for (KegPouringRecipe recipe2 : Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(pouringRecipe -> {
                    if (pouringRecipe.isStrict()) {
                        return pouringRecipe.getRawFluid().matches(((KegMenu)this.menu).kegTank.getAbstractedFluid());
                    }
                    return pouringRecipe.getRawFluid().fluid().isSame(((KegMenu)this.menu).kegTank.getAbstractedFluid().fluid());
                }).sorted(Comparator.comparing(recipe -> recipe.getContainer().getItem().getDescription().getString())).toList()) {
                    if (amountAdded > 0) {
                        component.append(", ");
                    }
                    component.append((Component)recipe2.getContainer().getItem().getDescription().plainCopy().withStyle(ChatFormatting.GRAY));
                    ++amountAdded;
                }
                return component;
            })).withStyle(ChatFormatting.GRAY);
            MutableComponent component = MutableComponent.create((ComponentContents)BrewinAndChewin.getHelper().getFluidDisplayName(((KegMenu)this.menu).kegTank.getAbstractedFluid()).getContents()).append((((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit().shortFormat(" (%s/%s") + ")").formatted(FluidUnit.convert(((KegMenu)this.menu).kegTank.getAbstractedFluid().amount(), FluidUnit.getLoaderUnit(), ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit()), FluidUnit.convert(((KegMenu)this.menu).kegTank.getFluidCapacity(), FluidUnit.getLoaderUnit(), ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit())));
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(List.of(component, containerComponent));
            if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).oppositeFluidDisplay() == BnCConfiguration.Client.DisplaySettings.ADVANCED_TOOLTIPS && this.minecraft.options.advancedItemTooltips || ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).oppositeFluidDisplay() == BnCConfiguration.Client.DisplaySettings.ALWAYS) {
                FluidUnit opposite = FluidUnit.getOpposite(((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit());
                components.add(MutableComponent.create((ComponentContents)Component.literal((String)opposite.shortFormat("%s/%s").formatted(FluidUnit.convert(((KegMenu)this.menu).kegTank.getAbstractedFluid().amount(), FluidUnit.getLoaderUnit(), opposite), FluidUnit.convert(((KegMenu)this.menu).kegTank.getFluidCapacity(), FluidUnit.getLoaderUnit(), opposite))).getContents()).withStyle(ChatFormatting.GRAY));
            }
            if (this.minecraft.options.advancedItemTooltips) {
                ResourceLocation fluidId = ((KegMenu)this.menu).kegTank.getAbstractedFluid().fluid().builtInRegistryHolder().key().location();
                components.add(Component.literal((String)fluidId.toString()).withStyle(ChatFormatting.DARK_GRAY));
                if (!((KegMenu)this.menu).kegTank.getAbstractedFluid().components().isEmpty()) {
                    components.add(Component.translatable((String)"item.components", (Object[])new Object[]{((KegMenu)this.menu).kegTank.getAbstractedFluid().components().size()}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
            gui.renderComponentTooltip(this.font, components, mouseX, mouseY);
        }
    }

    private void renderTemperatureTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        block8: {
            block9: {
                Recipe recipe;
                if (!this.isHovering(35, 54, 42, 5, mouseX, mouseY)) break block8;
                if (this.recipeBookComponent.getGhostRecipe() == null || !((recipe = this.recipeBookComponent.getGhostRecipe().value()) instanceof KegFermentingRecipe)) break block9;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(((KegMenu)this.menu).getKegTemperature(), fermentingRecipe.getTemperature())) break block8;
            }
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            MutableComponent key = switch (((KegMenu)this.menu).getKegTemperature()) {
                case 1 -> BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                case 2 -> BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                case 4 -> BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                case 5 -> BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                default -> BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
            };
            tooltip.add(key);
            gui.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
        super.renderLabels(gui, mouseX, mouseY);
        gui.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        KegFermentingRecipe fermentingRecipe;
        Recipe recipe;
        AbstractedFluidStack fluidStack;
        int temp;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        gui.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int l = ((KegMenu)this.menu).getFermentProgressionScaled();
        gui.blit(BACKGROUND_TEXTURE, this.leftPos + PROGRESS_ARROW.x(), this.topPos + PROGRESS_ARROW.y(), 176, 4, l + 1, PROGRESS_ARROW.height());
        if (((KegMenu)this.menu).isFermenting()) {
            int bubScale = (int)(((KegMenu)this.menu).getProgression() / 80.0f * (float)LEFT_BUBBLE.height()) % (LEFT_BUBBLE.height() + 1);
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + LEFT_BUBBLE.x(), this.topPos + LEFT_BUBBLE.y() - bubScale, 176, 79 - bubScale, LEFT_BUBBLE.width(), bubScale + 1);
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + RIGHT_BUBBLE.x(), this.topPos + RIGHT_BUBBLE.y() - bubScale, 186, 79 - bubScale, RIGHT_BUBBLE.width(), bubScale + 1);
        }
        if ((temp = ((KegMenu)this.menu).getKegTemperature()) == 1) {
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + COLD_BAR.x(), this.topPos + COLD_BAR.y(), 176, 0, COLD_BAR.width(), COLD_BAR.height());
        }
        if (temp < 3) {
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + CHILLY_BAR.x(), this.topPos + CHILLY_BAR.y(), 184, 0, CHILLY_BAR.width(), CHILLY_BAR.height());
        }
        if (temp > 3) {
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + WARM_BAR.x(), this.topPos + WARM_BAR.y(), 201, 0, WARM_BAR.width(), WARM_BAR.height());
        }
        if (temp == 5) {
            gui.blit(BACKGROUND_TEXTURE, this.leftPos + HOT_BAR.x(), this.topPos + HOT_BAR.y(), 210, 0, HOT_BAR.width(), HOT_BAR.height());
        }
        if (!(fluidStack = ((KegMenu)this.menu).kegTank.getAbstractedFluid()).isEmpty() && (this.recipeBookComponent.getGhostRecipe() == null || !((recipe = this.recipeBookComponent.getGhostRecipe().value()) instanceof KegFermentingRecipe) || (fermentingRecipe = (KegFermentingRecipe)recipe).getFluidIngredient().isEmpty() && ((KegMenu)this.menu).kegTank.isEmpty() || fermentingRecipe.getFluidIngredient().isPresent() && fermentingRecipe.getFluidIngredient().get().ingredient().matches(fluidStack))) {
            if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
                BrewinAndChewinClient.getHelper().renderFluidInKeg(fluidStack, gui, this.leftPos + 120, this.topPos + 19, 1.0f);
            }
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), fluidStack).copy();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                if (kegPouringRecipe.isStrict()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()));
                }
                return ItemStack.isSameItem((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()));
            }).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min(((KegMenu)this.menu).kegTank.getFluidCapacity(), ((KegMenu)this.menu).kegTank.getAbstractedFluid().amount()) / kegPouringRecipe.getLoaderAmount())).orElse(1);
            itemDisplay.setCount(pourCount);
            if (!itemDisplay.isEmpty()) {
                gui.renderItem(itemDisplay, this.leftPos + 124, this.topPos + 23);
                gui.renderItemDecorations(this.minecraft.font, itemDisplay, this.leftPos + 124, this.topPos + 23);
            }
        }
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.isVisible()) && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        if (this.recipeBookComponent.mouseClicked(mouseX, mouseY, buttonId)) {
            this.setFocused((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() || super.mouseClicked(mouseX, mouseY, buttonId);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int x, int y, int buttonIdx) {
        boolean flag = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + this.imageWidth) || mouseY >= (double)(y + this.imageHeight);
        return flag && this.recipeBookComponent.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, buttonIdx);
    }

    protected void slotClicked(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.slotClicked(slot, mouseX, mouseY, clickType);
        this.recipeBookComponent.slotClicked(slot);
    }

    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }
}

