/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.container.KegStackedContents;
import umpaz.brewinandchewin.common.crafting.FluidIngredientWithAmount;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.mixin.client.GhostRecipeAccessor;
import umpaz.brewinandchewin.common.mixin.client.RecipeBookComponentAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegRecipeBookComponent
extends RecipeBookComponent {
    private final RecipeManager recipeManager;
    private static final WidgetSprites FILTER_SPRITES = new WidgetSprites(BrewinAndChewin.asResource("recipe_book/keg_filter_enabled"), BrewinAndChewin.asResource("recipe_book/keg_filter_disabled"), BrewinAndChewin.asResource("recipe_book/keg_filter_enabled_highlighted"), BrewinAndChewin.asResource("recipe_book/keg_filter_disabled_highlighted"));
    private static final Component FILTER_NAME = Component.translatable((String)"brewinandchewin.container.recipe_book.fermentable");

    public KegRecipeBookComponent(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public void initVisuals() {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            ((RecipeBookComponentAccessor)((Object)this)).brewinandchewin$setStackedContents(new KegStackedContents(kegMenu, this.recipeManager));
        }
        super.initVisuals();
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_SPRITES);
    }

    public void hide() {
        this.setVisible(false);
    }

    @Nullable
    public RecipeHolder<?> getGhostRecipe() {
        return this.ghostRecipe.getRecipe();
    }

    @NotNull
    protected Component getRecipeFilterName() {
        return FILTER_NAME;
    }

    public void renderTooltip(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        RecipeBookMenu recipeBookMenu;
        super.renderTooltip(gui, renderX, renderY, mouseX, mouseY);
        if (this.isVisible() && (recipeBookMenu = this.menu) instanceof KegMenu) {
            Recipe recipe;
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            RecipeHolder recipe2 = this.ghostRecipe.getRecipe();
            if (recipe2 != null && (recipe = recipe2.value()) instanceof KegFermentingRecipe) {
                Optional<FluidIngredientWithAmount> ingredient;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    this.renderTemperatureTooltip(gui, renderX, renderY, mouseX, mouseY);
                }
                if ((ingredient = fermentingRecipe.getFluidIngredient()).isEmpty() || ingredient.get().ingredient().displayStacks().isEmpty()) {
                    return;
                }
                List<AbstractedFluidStack> ingredients = ingredient.get().ingredient().displayStacks();
                AbstractedFluidStack fluidStack = ingredients.get(Mth.floor((float)(((GhostRecipeAccessor)this.ghostRecipe).brewinandchewin$getTime() / 30.0f)) % ingredients.size());
                fluidStack = new AbstractedFluidStack(fluidStack.fluid(), ingredient.get().amount(), fluidStack.components(), ingredient.get().unit().orElse(FluidUnit.getLoaderUnit()), fluidStack.loaderSpecific());
                if (!kegMenu.kegTank.getAbstractedFluid().fluid().isSame(fluidStack.fluid())) {
                    this.renderTankTooltip(gui, renderX, renderY, mouseX, mouseY, fluidStack);
                }
            }
        }
    }

    public void renderGhostRecipe(GuiGraphics gui, int leftPos, int topPos, boolean singleItem, float partialTick) {
        this.ghostRecipe.render(gui, this.minecraft, leftPos, topPos, singleItem, partialTick);
        if (this.ghostRecipe.getRecipe() == null) {
            return;
        }
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            RecipeHolder recipe = this.ghostRecipe.getRecipe();
            Recipe recipe2 = recipe.value();
            if (recipe2 instanceof KegFermentingRecipe) {
                Optional<FluidIngredientWithAmount> fluidIngredient;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe2;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                    int temp = fermentingRecipe.getTemperature();
                    int minX = leftPos + 52;
                    int maxX = minX + 8;
                    if (temp < 3) {
                        gui.blit(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.CHILLY_BAR.x(), topPos + KegScreen.CHILLY_BAR.y(), 184, 0, KegScreen.CHILLY_BAR.width(), KegScreen.CHILLY_BAR.height());
                        minX = leftPos + KegScreen.CHILLY_BAR.x();
                    }
                    if (temp == 1) {
                        gui.blit(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.COLD_BAR.x(), topPos + KegScreen.COLD_BAR.y(), 176, 0, KegScreen.COLD_BAR.width(), KegScreen.COLD_BAR.height());
                        minX = leftPos + KegScreen.COLD_BAR.x();
                    }
                    if (temp > 3) {
                        gui.blit(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.WARM_BAR.x(), topPos + KegScreen.WARM_BAR.y(), 201, 0, KegScreen.WARM_BAR.width(), KegScreen.WARM_BAR.height());
                        maxX = leftPos + KegScreen.WARM_BAR.x() + KegScreen.WARM_BAR.width();
                    }
                    if (temp == 5) {
                        gui.blit(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.HOT_BAR.x(), topPos + KegScreen.HOT_BAR.y(), 210, 0, KegScreen.HOT_BAR.width(), KegScreen.HOT_BAR.height());
                        maxX = leftPos + KegScreen.HOT_BAR.x() + KegScreen.HOT_BAR.width();
                    }
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    gui.fill(minX, topPos + 55, maxX, topPos + 58, 0x30FF0000);
                }
                if ((fluidIngredient = fermentingRecipe.getFluidIngredient()).isPresent() && !fluidIngredient.get().ingredient().displayStacks().isEmpty()) {
                    List<AbstractedFluidStack> ingredients = fluidIngredient.get().ingredient().displayStacks();
                    AbstractedFluidStack fluidStack = ingredients.get(Mth.floor((float)(((GhostRecipeAccessor)this.ghostRecipe).brewinandchewin$getTime() / 30.0f)) % ingredients.size());
                    fluidStack = new AbstractedFluidStack(fluidStack.fluid(), fluidIngredient.get().amount(), fluidStack.components(), fluidIngredient.get().unit().orElse(FluidUnit.getLoaderUnit()), null);
                    if (kegMenu.kegTank.isEmpty() || !kegMenu.kegTank.getAbstractedFluid().fluid().isSame(fluidStack.fluid())) {
                        if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
                            BrewinAndChewinClient.getHelper().renderFluidInKeg(fluidStack, gui, leftPos + 120, topPos + 19, 0.6f);
                            gui.fill(RenderType.guiGhostRecipeOverlay(), leftPos + 120, topPos + 19, leftPos + 120 + 16 + 8, topPos + 31 + 16, 0x30FFFFFF);
                        }
                        gui.fill(leftPos + 120, topPos + 19, leftPos + 120 + 16 + 8, topPos + 31 + 16, 0x30FF0000);
                        ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), fluidStack).copy();
                        int pourCount = (int)(Math.min(fermentingRecipe.getFluidIngredient().get().loaderAmount(), kegMenu.kegTank.getFluidCapacity()) / FluidUnit.convert(250L, FluidUnit.MILLIBUCKET, FluidUnit.getLoaderUnit()));
                        itemDisplay.setCount(pourCount);
                        if (!itemDisplay.isEmpty()) {
                            int itemX = leftPos + 124;
                            int itemY = topPos + 23;
                            gui.renderItem(itemDisplay, itemX, itemY);
                            gui.fill(RenderType.guiGhostRecipeOverlay(), itemX, itemY, itemX + 16, itemY + 16, 0x30FFFFFF);
                            gui.renderItemDecorations(this.minecraft.font, itemDisplay, itemX, itemY);
                        }
                    }
                } else if (fluidIngredient.isEmpty() && !kegMenu.kegTank.isEmpty()) {
                    gui.fill(leftPos + 120, topPos + 19, leftPos + 120 + 16 + 8, topPos + 31 + 16, 0x30FF0000);
                }
            }
        }
    }

    private void renderTankTooltip(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY, AbstractedFluidStack stack) {
        RecipeBookMenu recipeBookMenu;
        if (this.isHovering(120, 19, 24, 28, mouseX - renderX, mouseY - renderY) && (recipeBookMenu = this.menu) instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            if (kegMenu.kegTank.isEmpty() || !kegMenu.kegTank.getAbstractedFluid().fluid().isSame(stack.fluid())) {
                MutableComponent component = MutableComponent.create((ComponentContents)BrewinAndChewin.getHelper().getFluidDisplayName(stack).getContents()).append((((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit().shortFormat(" (%s/%s") + ")").formatted(FluidUnit.convert(stack.amount(), stack.unit(), ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit()), FluidUnit.convert(kegMenu.kegTank.getFluidCapacity(), FluidUnit.getLoaderUnit(), ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit())));
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(List.of(component));
                if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).oppositeFluidDisplay() == BnCConfiguration.Client.DisplaySettings.ADVANCED_TOOLTIPS && this.minecraft.options.advancedItemTooltips || ((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).oppositeFluidDisplay() == BnCConfiguration.Client.DisplaySettings.ALWAYS) {
                    FluidUnit opposite = FluidUnit.getOpposite(((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).displayUnit());
                    components.add(MutableComponent.create((ComponentContents)Component.literal((String)opposite.shortFormat("%s/%s").formatted(FluidUnit.convert(stack.amount(), stack.unit(), opposite), FluidUnit.convert(kegMenu.kegTank.getFluidCapacity(), FluidUnit.getLoaderUnit(), opposite))).getContents()).withStyle(ChatFormatting.GRAY));
                }
                if (this.minecraft.options.advancedItemTooltips) {
                    ResourceLocation fluidId = stack.fluid().builtInRegistryHolder().key().location();
                    components.add(Component.literal((String)fluidId.toString()).withStyle(ChatFormatting.DARK_GRAY));
                    if (!stack.components().isEmpty()) {
                        components.add(Component.translatable((String)"item.components", (Object[])new Object[]{stack.components().size()}).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
                gui.renderComponentTooltip(this.minecraft.font, components, mouseX, mouseY);
            }
        }
    }

    private void renderTemperatureTooltip(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        RecipeBookMenu recipeBookMenu;
        if (this.isHovering(34, 54, 43, 5, mouseX - renderX, mouseY - renderY) && (recipeBookMenu = this.menu) instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            recipeBookMenu = this.getGhostRecipe().value();
            if (recipeBookMenu instanceof KegFermentingRecipe) {
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipeBookMenu;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    MutableComponent key = switch (fermentingRecipe.getTemperature()) {
                        case 1 -> BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                        case 2 -> BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                        case 4 -> BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                        case 5 -> BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                        default -> BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
                    };
                    gui.renderComponentTooltip(this.minecraft.font, List.of(Component.translatable((String)"brewinandchewin.container.keg.temperature_requirement", (Object[])new Object[]{key})), mouseX, mouseY);
                }
            }
        }
    }

    private boolean isHovering(int x, int y, int xWidth, int yWidth, int mouseX, int mouseY) {
        int maxX = x + xWidth;
        int maxY = y + yWidth;
        return mouseX >= x && mouseX <= maxX && mouseY >= y && mouseY <= maxY;
    }

    public void setupGhostRecipe(RecipeHolder<?> recipe, List<Slot> slots) {
        KegFermentingRecipe fermentingRecipe;
        Recipe recipe2;
        ItemStack resultStack = recipe.value().getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()).copy();
        this.ghostRecipe.setRecipe(recipe);
        if (slots.get(5).getItem().isEmpty()) {
            this.ghostRecipe.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{resultStack}), slots.get((int)5).x, slots.get((int)5).y);
        }
        if ((recipe2 = recipe.value()) instanceof KegFermentingRecipe && (fermentingRecipe = (KegFermentingRecipe)recipe2).getResult().left().isPresent()) {
            Optional<RecipeHolder> pouringRecipe = this.recipeManager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().filter(kegPouringRecipe -> ((KegPouringRecipe)kegPouringRecipe.value()).getRawFluid().matches((AbstractedFluidStack)fermentingRecipe.getResult().left().get())).findFirst();
            pouringRecipe.ifPresent(kegPouringRecipe -> this.ghostRecipe.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{((KegPouringRecipe)kegPouringRecipe.value()).getContainer()}), ((Slot)slots.get((int)4)).x, ((Slot)slots.get((int)4)).y));
        }
        this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, recipe.value().getIngredients().iterator(), 0);
    }
}

