/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeNoteParticleData;

public class JukeboxUpgradeNoteParticle
extends TextureSheetParticle {
    protected JukeboxUpgradeNoteParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.01f;
        this.yd *= (double)0.05f;
        this.zd *= (double)0.01f;
        this.yd += 0.01;
        double color = level.getRandom().nextDouble();
        this.rCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)(((float)color + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.quadSize *= 1.5f;
        this.lifetime = 20;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<JukeboxUpgradeNoteParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(JukeboxUpgradeNoteParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            JukeboxUpgradeNoteParticle particle = new JukeboxUpgradeNoteParticle(level, x, y, z);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

