/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2core.serial.loot.LootHelper;
import java.util.Locale;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public enum FDMelons implements PlantDataEntry<FDMelons>
{
    HAMIMELON(2, 0.3f, true);

    private final BlockEntry<Block> melon;
    private final BlockEntry<StemBlock> stem;
    private final BlockEntry<AttachedStemBlock> attachedStem;
    private final ItemEntry<Item> slice;
    private final ItemEntry<ItemNameBlockItem> seed;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDMelons(int food, float sat, boolean fast) {
        String name = this.name().toLowerCase(Locale.ROOT);
        this.configKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FruitsDelight.loc(name));
        this.placementKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FruitsDelight.loc(name));
        ResourceKey blockKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FruitsDelight.loc(name));
        ResourceKey stemKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FruitsDelight.loc(name + "_stem"));
        ResourceKey attachKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FruitsDelight.loc("attached_" + name + "_stem"));
        ResourceKey itemKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FruitsDelight.loc(name + "_seeds"));
        this.melon = ((BlockBuilder)FruitsDelight.REGISTRATE.block(name, p -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON))).blockstate(this::buildMelonModel).loot(this::buildMelonLoot).tag(new TagKey[]{BlockTags.ENDERMAN_HOLDABLE, BlockTags.MINEABLE_WITH_AXE, BlockTags.SWORD_EFFICIENT}).item().build()).register();
        this.stem = FruitsDelight.REGISTRATE.block(name + "_stem", p -> new StemBlock(blockKey, attachKey, itemKey, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM))).blockstate(this::buildStemModel).loot(this::buildStemLoot).color(() -> () -> FDMelons::stemColor).tag(new TagKey[]{BlockTags.MAINTAINS_FARMLAND, BlockTags.MINEABLE_WITH_AXE, BlockTags.SWORD_EFFICIENT}).register();
        this.attachedStem = FruitsDelight.REGISTRATE.block("attached_" + name + "_stem", p -> new AttachedStemBlock(stemKey, blockKey, itemKey, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ATTACHED_MELON_STEM))).blockstate(this::buildAttachedStemModel).loot(this::buildAttachedStemLoot).color(() -> () -> FDMelons::attachedColor).tag(new TagKey[]{BlockTags.MAINTAINS_FARMLAND, BlockTags.MINEABLE_WITH_AXE, BlockTags.SWORD_EFFICIENT}).register();
        this.slice = FruitsDelight.REGISTRATE.item(name + "_slice", p -> new Item(p.food(FDMelons.food(food, sat, fast)))).register();
        this.seed = FruitsDelight.REGISTRATE.item(name + "_seeds", p -> new ItemNameBlockItem((Block)this.getStem(), p)).register();
    }

    public Block getMelonBlock() {
        return (Block)this.melon.get();
    }

    public StemBlock getStem() {
        return (StemBlock)this.stem.get();
    }

    public AttachedStemBlock getAttachedStem() {
        return (AttachedStemBlock)this.attachedStem.get();
    }

    public Item getSlice() {
        return (Item)this.slice.get();
    }

    public ItemNameBlockItem getSeed() {
        return (ItemNameBlockItem)this.seed.get();
    }

    @Override
    public void registerConfigs(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        FeatureUtils.register(ctx, this.configKey, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(24, 5, 3, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)this.getMelonBlock())), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.noFluid(), BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SAND})}))));
    }

    @Override
    public void registerPlacements(BootstrapContext<PlacedFeature> ctx) {
        PlacementUtils.register(ctx, this.placementKey, (Holder)ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    @Override
    public void registerComposter(BiConsumer<Item, Float> builder) {
        builder.accept((Item)this.getSeed(), Float.valueOf(0.3f));
        builder.accept(this.getSlice(), Float.valueOf(0.5f));
        builder.accept(this.getMelonBlock().asItem(), Float.valueOf(0.65f));
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        pvd.singleItem(DataIngredient.items((ItemLike)this.getSlice(), (ItemLike[])new Item[0]), RecipeCategory.MISC, this::getSeed, 1, 1);
        pvd.square(DataIngredient.items((ItemLike)this.getSlice(), (ItemLike[])new Item[0]), RecipeCategory.MISC, this::getMelonBlock, false);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this.getMelonBlock()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)this.getSlice(), (int)9, (int)1).build((RecipeOutput)pvd, FruitsDelight.loc(this.getName() + "_cutting"));
    }

    private void buildMelonModel(DataGenContext<Block, Block> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.simpleBlock((Block)ctx.get(), (ModelFile)pvd.models().cubeColumn(ctx.getName(), pvd.modLoc("block/" + name + "_side"), pvd.modLoc("block/" + name + "_top")));
    }

    private void buildStemModel(DataGenContext<Block, StemBlock> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)StemBlock.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName() + "_stage" + age, "block/stem_growth" + age)).texture("stem", pvd.modLoc("block/" + name + "_stem"))).renderType("cutout")).build();
        });
    }

    private void buildAttachedStemModel(DataGenContext<Block, AttachedStemBlock> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName(), "block/stem_fruit")).texture("stem", pvd.modLoc("block/" + name + "_stem"))).texture("upperstem", pvd.modLoc("block/" + name + "_attached"))).renderType("cutout"), 270);
    }

    private void buildMelonLoot(RegistrateBlockLootTables pvd, Block block) {
        LootHelper helper = new LootHelper(pvd);
        pvd.add(block, pvd.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)pvd.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)this.getSlice()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f))).apply(helper.fortuneCount(1)).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)9))))));
    }

    private void buildStemLoot(RegistrateBlockLootTables pvd, StemBlock block) {
        pvd.add((Block)block, pvd.createStemDrops((Block)block, (Item)this.getSeed()));
    }

    private void buildAttachedStemLoot(RegistrateBlockLootTables pvd, AttachedStemBlock block) {
        pvd.add((Block)block, pvd.createAttachedStemDrops((Block)block, (Item)this.getSeed()));
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().nutrition(food).saturationModifier(sat);
        if (fast) {
            ans.fast();
        }
        return ans.build();
    }

    private static int stemColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        int i = (Integer)state.getValue((Property)StemBlock.AGE);
        return i << 21 | 255 - (i << 3) << 8 | i << 2;
    }

    private static int attachedColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        return 14731036;
    }

    public static void register() {
    }
}

