/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.effects;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class CyclingEffect
extends MobEffect {
    public CyclingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int lv) {
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.experienceLevel <= 1) {
            return true;
        }
        if (player.takeXpDelay > 0) {
            return true;
        }
        int exp = Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
        --player.experienceLevel;
        ++player.experienceLevel;
        player.giveExperiencePoints(-(exp += player.getXpNeededForNextLevel()));
        ExperienceOrb.award((ServerLevel)player.serverLevel(), (Vec3)player.position(), (int)exp);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int tick, int lv) {
        return tick % (20 << lv) == 0;
    }
}

