/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import dev.xkmc.fruitsdelight.content.block.JelloBlock;
import dev.xkmc.fruitsdelight.events.BlockEffectToClient;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.food.IFruitType;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class JamBlock
extends HoneyBlock {
    public final IFruitType fruit;

    public JamBlock(BlockBehaviour.Properties properties, IFruitType fruit) {
        super(properties);
        this.fruit = fruit;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        Block block = other.getBlock();
        if (block instanceof JelloBlock) {
            JelloBlock jello = (JelloBlock)block;
            return jello.fruit == this.fruit;
        }
        if (other.isStickyBlock() && other.getBlock() != this) {
            return false;
        }
        return super.canStickTo(state, other);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.TOOLTIP_JAM.get(new Object[0]));
    }

    public void showJamSlideParticles(Entity entity) {
        if (entity.level().isClientSide()) {
            this.showParticles(entity, 5);
        } else {
            FruitsDelight.HANDLER.toTrackingPlayers((SimplePacketBase)new BlockEffectToClient((Block)this, entity.getId(), BlockEffectToClient.Type.JAM_SLIDE), entity);
        }
    }

    public void showJamJumpParticles(Entity entity) {
        if (entity.level().isClientSide()) {
            this.showParticles(entity, 10);
        } else {
            FruitsDelight.HANDLER.toTrackingPlayers((SimplePacketBase)new BlockEffectToClient((Block)this, entity.getId(), BlockEffectToClient.Type.JAM_JUMP), entity);
        }
    }

    private void showParticles(Entity entity, int count) {
        if (entity.level().isClientSide) {
            BlockState state = this.defaultBlockState();
            for (int i = 0; i < count; ++i) {
                entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

